%define _unpackaged_files_terminate_build 1
%define java_home %_jvmdir/jre

%def_without check

%define nss_version 3.44

Name: jss
Version: 4.8.1
Release: alt1.c9.1

Summary: Java Security Services (JSS)
License: MPL-1.1 or GPLv2+ or LGPLv2+
Group: System/Libraries
# Source-git: https://github.com/dogtagpki/jss.git
Url: http://www.dogtagpki.org/wiki/JSS

Source0: %name-%version.tar
Source1: jss.watch
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-macros-java
BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: glassfish-jaxb-api
BuildRequires: /proc
BuildRequires: cmake
BuildRequires: java-1.8.0-openjdk-devel
BuildRequires: jpackage-generic-compat
BuildRequires: libnss-devel >= %nss_version
BuildRequires: libnspr-devel
BuildRequires: apache-commons-lang3
BuildRequires: slf4j
BuildRequires: slf4j-jdk14

BuildRequires: ctest
BuildRequires: junit
BuildRequires: nss-utils >= %nss_version

Requires: apache-commons-lang3
Requires: glassfish-jaxb-api
Requires: java-1.8.0-openjdk-headless
Requires: slf4j
Requires: libnss >= %nss_version

%description
Network Security Services for Java (JSS) is a Java interface to NSS. JSS
supports most of the security standards and encryption technologies supported by
NSS. JSS also provides a pure Java interface for ASN.1 types and BER/DER
encoding.

JSS offers a implementation of Java SSL sockets that uses NSS's SSL/TLS
implementation rather than Sun's JSSE implementation. You might want to use
JSS's own SSL classes if you want to use some of the capabilities found in NSS's
SSL/TLS library but not found in JSSE.

NSS is the cryptographic module where all cryptographic operations are
performed. JSS essentially provides a Java JNI bridge to NSS C shared libraries.
When NSS is put in FIPS mode, JSS ensures FIPS compliance by ensuring that all
cryptographic operations are performed by the NSS cryptographic module.

%package javadoc
Summary: Java Security Services (JSS) Javadocs
Group: Development/Java
Requires: %name = %EVR
BuildArch: noarch

%description javadoc
This package contains the API documentation for JSS.

%prep
%setup
%patch -p1

%build
# Enable compiler optimizations and disable debugging code
# NOTE: If you ever need to create a debug build with optimizations disabled
# just comment out this line and change in the %%install section below the
# line that copies jars xpclass.jar to be xpclass_dbg.jar
export BUILD_OPT=1

%cmake \
    -DJAVA_HOME=%java_home \
    ..

%cmake_build all javadoc

%if_with check
%check
# FIPS is not enabled in kernel
cat > BUILD/CTestCustom.cmake <<EOF
set(CTEST_CUSTOM_TESTS_IGNORE
   Enable_FipsMODE
)
EOF
%cmake_build ARGS=--output-on-failure test
%endif

%install
install -d -m 0755 %buildroot%_jnidir
install -m 644 BUILD/jss4.jar %buildroot%_jnidir/jss4.jar

# We have to use the name libjss4.so because this is dynamically
# loaded by the jar file.
install -d -m 0755 %buildroot%_libdir/jss
install -m 0755 BUILD/libjss4.so %buildroot%_libdir/jss/
pushd  %buildroot%_libdir/jss
    ln -fs %_jnidir/jss4.jar jss4.jar
popd

# javadoc
install -d -m 0755 %buildroot%_javadocdir/%name-%version
cp -rp BUILD/docs/* %buildroot%_javadocdir/%name-%version
cp -p jss.html %buildroot%_javadocdir/%name-%version
cp -p *.txt %buildroot%_javadocdir/%name-%version

%files
%dir %_libdir/jss
%_libdir/jss/jss4.jar
%_libdir/jss/libjss4.so
%_jnidir/jss4.jar

%files javadoc
%_javadocdir/%name-%version

%changelog
