Group: Graphical desktop/Other
# BEGIN SourceDeps(oneline):
BuildRequires: libX11-devel libXext-devel libpng-devel xorg-xproto-devel
# END SourceDeps(oneline)
%define fedora 26
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           jwm
Version:        2.3.7
Release:        alt1_3
Summary:        Joe's Window Manager

License:        GPLv2+
URL:            http://joewing.net/projects/jwm/
Source0:        %{url}/releases/%{name}-%{version}.tar.xz
Source1:        %{name}.desktop

BuildRequires:  gcc-common
BuildRequires:  pkgconfig(libpng)
%if 0%{?fedora} > 24
BuildRequires:  pkgconfig(libjpeg)
%else
BuildRequires:  libjpeg-devel
%endif
BuildRequires:  pkgconfig(cairo)
BuildRequires:  pkgconfig(librsvg-2.0)
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(xft)
BuildRequires:  pkgconfig(xrender)
BuildRequires:  pkgconfig(fribidi)
BuildRequires:  libXpm libXpm-devel
BuildRequires:  libXmu-devel
BuildRequires:  libXinerama-devel
BuildRequires:  gettext gettext-tools
Requires:     /usr/bin/xterm
Requires:     /usr/bin/xlock
Source44: import.info
Patch33: jwm-2.3.7-alt-config-file.patch
Source45: jwm.method
Source46: jwm.wmsession
Source47: jwm-conf.tar
Source48: startjwm

%description
JWM is a window manager for the X11 Window System. It's written in C and uses
only Xlib at a minimum. The following libraries can also be used if available:

* cairo and librsvg2 for SVG icons and backgrounds.
* fribidi for bi-directional text support.
* libjpeg for JPEG icons and backgrounds.
* libpng for PNG icons and backgrounds.
* libXext for the shape extension.
* libXrender for the render extension.
* libXmu for rounded corners.
* libXft for anti-aliased and true type fonts.
* libXinerama for multiple head support.
* libXpm for XPM icons and backgrounds.

JWM supports MWM and Extended Window Manager Hints (EWMH).

Note that Fedora package is built with all supported features enabled.

%prep
%setup -q


# Preserve timestamps in installation
sed -i -e 's|install -m|install -pm|g' Makefile.in
%patch33 -p1

%build
# -Werror
CFLAGS="$CFLAGS -O3 -Wall"
%autoreconf
%configure \
        --enable-debug \
        --enable-shade \
        --sysconfdir=%_sysconfdir/X11/jwm 
%make_build

%install
%makeinstall_std

mkdir -p %{buildroot}%{_datadir}/xsessions
install -Dpm0644 %{SOURCE1} %{buildroot}%{_datadir}/xsessions/

%find_lang %{name}

tar -xC %buildroot/%_sysconfdir/X11/jwm -f %SOURCE47
rm -f -- %buildroot/%_sysconfdir/X11/jwm/system.jwmrc

# install -m755 %SOURCE48 %buildroot/%_bindir/
install -D -m644 %SOURCE46 %buildroot/%_sysconfdir/X11/wmsession.d/jwm
install -D -m 755 %{SOURCE45} %buildroot%_sysconfdir/menu-methods/jwm

%files -f %{name}.lang
%doc LICENSE
%doc ChangeLog README.md
%doc %{_mandir}/man1/%{name}.1*
%{_bindir}/%{name}
%config(noreplace) %{_sysconfdir}/X11/jwm/*
%{_datadir}/xsessions/%{name}.desktop
%{_datadir}/%{name}/
%config %_sysconfdir/menu-methods/jwm
%config %_sysconfdir/X11/wmsession.d/jwm

%changelog
