%def_without ru_doc

Name:    kamoso
Version: 19.12.3
Release: alt1

Group:   Video
Summary: Application for taking pictures and videos from a webcam
URL:     https://userbase.kde.org/Kamoso

License: GPLv2+

# Download from http://download.kde.org/stable/release-service/19.12.0/src/kamoso-19.12.0.tar.xz
Source0: %name-%version.tar
Source1: %name.watch
Source2: po.tar
Source3: kamoso-ru.po
Source4: kamoso-ru-doc.po
Patch1:  kamoso-add-l10n.patch
Patch2:  kamoso-alt-fix-l10n-ru.patch

BuildRequires(pre): rpm-build-kf5
BuildRequires: extra-cmake-modules gcc-c++
BuildRequires: gettext-tools
%if_with ru_doc
BuildRequires: itstool
%endif
BuildRequires: qt5-declarative-devel
BuildRequires: qt5-graphicaleffects
BuildRequires: kf5-kauth-devel
BuildRequires: kf5-kbookmarks-devel
BuildRequires: kf5-kcodecs-devel
BuildRequires: kf5-kcompletion-devel
BuildRequires: kf5-kconfig-devel
BuildRequires: kf5-kconfigwidgets-devel
BuildRequires: kf5-kcoreaddons-devel
BuildRequires: kf5-kdeclarative-devel
BuildRequires: kf5-kdoctools-devel
BuildRequires: kf5-ki18n-devel
BuildRequires: kf5-kio-devel
BuildRequires: kf5-kirigami-devel
BuildRequires: kf5-kitemviews-devel
BuildRequires: kf5-kjobwidgets-devel
BuildRequires: kf5-knotifications-devel
BuildRequires: kf5-kpackage-devel
BuildRequires: kf5-kservice-devel
BuildRequires: kf5-kwidgetsaddons-devel
BuildRequires: kf5-kxmlgui-devel
BuildRequires: kf5-purpose-devel
BuildRequires: kf5-solid-devel
BuildRequires: libkf5quickaddons
BuildRequires: kf5-kdoctools-devel-static
BuildRequires: kf5-kdoctools
BuildRequires: libudev-devel
BuildRequires: gstreamer1.0-devel
BuildRequires: gst-plugins1.0-devel

Requires: libkf5quickaddons
Requires: kf5-purpose
Requires: kf5-ki18n-common

%description
Kamoso is an application to take pictures and videos out of your webcam.

%prep
%setup
%patch1 -p1
%patch2 -p1
tar xf %SOURCE2
# Merge Russian localization to current version
msgmerge %SOURCE3 po/ru/kamoso.po -o $TMPDIR/kamoso.po
cp $TMPDIR/kamoso.po po/ru/kamoso.po
%if_with ru_doc
# Apply Russian localization to documentation
msgfmt %SOURCE4 -o $TMPDIR/kamoso.mo
itstool -m $TMPDIR/kamoso.mo -o ru/ doc/index.docbook
%endif

%build
%add_optflags -I%_libdir/gstreamer-1.0/include
%K5init no_altplace
%K5build

%install
%K5install
%find_lang %name --all

%files -f %name.lang
%doc AUTHORS COPYING* README TODO
%_K5bin/%name
%_K5icon/hicolor/*/*/*.*
%_K5xdgapp/*%name.desktop
%_datadir/metainfo/org.kde.kamoso.appdata.xml
%doc %_K5doc/*/%name
%_datadir/sounds/kamoso-shutter.wav
%_libdir/gstreamer-1.0/gstkamosoqt5videosink.so
%_K5notif/%name.notifyrc

%changelog
