%define nvIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define nvIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define nvIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define nvIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%define module_name		nvidia
%define modesetmodule_name	nvidia-modeset
%define uvmmodule_name		nvidia-uvm
%define drmmodule_name		nvidia-drm
%define package_version	550.67
%define module_version	%package_version
%ifarch %ix86 armh
%define module_version	390.157
%endif
%define module_release	alt1
%define flavour		un-def
%define karch x86_64 aarch64 %ix86

%setup_kernel_module %flavour
%define module_srcver	%(echo %module_version | tr -d .)
%define xorg_ver %{get_version xorg-server}
%if "%xorg_ver" == ""
%define xorg_ver %{get_version xorg-x11-server}
%endif

%define legacy7 %nil
%nvIF_ver_lt %xorg_ver 99
%define legacy7 470.239.06
%endif
%define legacy7_src %(echo %legacy7 | tr -d .)

%define legacy6 %nil
%nvIF_ver_lt %xorg_ver 99
%define legacy6 390.157
%endif
%define legacy6_src %(echo %legacy6 | tr -d .)

%define legacy5 %nil
%nvIF_ver_lt %xorg_ver 1.21
%define legacy5 340.108
%endif
%define legacy5_src %(echo %legacy5 | tr -d .)

%define legacy4 %nil
%nvIF_ver_lt %xorg_ver 1.20
%define legacy4 304.137
%endif
%define legacy4_src %(echo %legacy4 | tr -d .)

%define legacy3 %nil
%nvIF_ver_lt %xorg_ver 1.16
%define legacy3 173.14.39
%endif
%define legacy3_src %(echo %legacy3 | tr -d .)

%define legacy2 %nil
%nvIF_ver_lt %xorg_ver 1.13
%define legacy2 96.43.23
%endif
%define legacy2_src %(echo %legacy2 | tr -d .)

%define legacy1 %nil
%nvIF_ver_lt %xorg_ver 1.6
%define legacy1 71.86.13
%endif
%define legacy1_src %(echo %legacy1 | tr -d .)

%ifarch %ix86 armh
%define legacy7 %nil
%define legacy6 %nil
%endif
%ifarch aarch64
%define legacy7 %nil
%define legacy6 %nil
%define legacy5 %nil
%define legacy4 %nil
%define legacy3 %nil
%define legacy2 %nil
%define legacy1 %nil
%endif
%define mod_ver_list %module_version %legacy7 %legacy6 %legacy5 %legacy4 %legacy3 %legacy2 %legacy1

%define module_dir /lib/modules/%kversion-%flavour-%krelease/nVidia
%define module_local_dir /lib/modules/nvidia
%define module_version_dir /lib/modules/%kversion-%flavour-%krelease/.versions
%define nvidia_workdir %_localstatedir/nvidia
%define module_ext .ko
%nvIF_ver_lt "%kversion" "2.5.0"
%define module_ext .o
%endif

Summary:	nVidia video card drivers
Name:		kernel-modules-%module_name-%flavour
Version:	%package_version
Release:	%module_release.%kcode.%kbuildrelease
License:	Proprietary
Group:		System/Kernel and hardware
URL:		http://www.nvidia.com

Packager:       Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveArch: %karch

BuildRequires(pre): rpm-build-kernel xorg-x11-server
BuildRequires(pre): kernel-headers-modules-un-def
BuildRequires: rpm-utils
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%module_name-%module_srcver
%if "%legacy7" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy7_src
%endif
%if "%legacy6" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy6_src
%endif
%if "%legacy5" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy5_src
%endif
%if "%legacy4" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy4_src
%endif
%if "%legacy3" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy3_src
%endif
%if "%legacy2" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy2_src
%endif
%if "%legacy1" != "%nil"
BuildRequires: kernel-source-%module_name-%legacy1_src
%endif

Provides:  	kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: 	kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: 	kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

Conflicts: modutils < 2.4.27-alt4

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
Requires: kernel-modules-drm-%flavour = %kepoch%kversion-%krelease
Requires:       nvidia_glx_%module_version
%if "%legacy7" != "%nil"
Requires:       nvidia_glx_%legacy7
%endif
%if "%legacy6" != "%nil"
Requires:       nvidia_glx_%legacy6
%endif
%if "%legacy5" != "%nil"
Requires:       nvidia_glx_%legacy5
%endif
%if "%legacy4" != "%nil"
Requires:       nvidia_glx_%legacy4
%endif
%if "%legacy3" != "%nil"
Requires:       nvidia_glx_%legacy3
%endif
%if "%legacy2" != "%nil"
Requires:       nvidia_glx_%legacy2
%endif
%if "%legacy1" != "%nil"
Requires:       nvidia_glx_%legacy1
%endif

%description
nVidia video card drivers that provide 3d and 2d graphics support for XFree86
Xserver.


%prep
%setup -cT
for ver in %mod_ver_list
do
    sffx=`echo "$ver"| sed -e "s|\.||g"`
    rm -rf kernel-source-%module_name-$sffx
    tar -jxvf %_usrsrc/kernel/sources/kernel-source-%module_name-$sffx.tar.bz2

    pushd kernel-source-%module_name-$sffx
    if [ -f Makefile.kbuild ] ; then
	rm -f makefile Makefile
	ln -s Makefile.kbuild Makefile
    fi
    popd
done


%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
for ver in %mod_ver_list
do
    sffx=`echo "$ver"| sed -e "s|\.||g"`
    pushd kernel-source-%module_name-$sffx
    INTO_KERNEL_SRCDIR=
    [ -d nvidia-modeset ] || \
	INTO_KERNEL_SRCDIR="-C %_usrsrc/linux-%kversion-%flavour"
    %make_build modules \
	$INTO_KERNEL_SRCDIR \
	M=$PWD \
	TEMP_DIR=$PWD/ \
	ARCH=%base_arch \
	SYSSRC=%_usrsrc/linux-%kversion-%flavour
	if [ -d uvm ] ; then
	    pushd uvm
	    cp -a ../Module.symvers .
	    %make_build modules \
		$INTO_KERNEL_SRCDIR \
		M=$PWD \
		TEMP_DIR=$PWD/ \
		ARCH=%base_arch \
		SYSSRC=%_usrsrc/linux-%kversion-%flavour
	    popd
	fi
    popd
done

%install
mkdir -p %buildroot/%module_dir
mkdir -p %buildroot/%module_local_dir
mkdir -p %buildroot/%module_version_dir
mkdir -p %buildroot/%nvidia_workdir

for ver in %mod_ver_list
do
    sffx=`echo "$ver"| sed -e "s|\.||g"`
    pushd kernel-source-%module_name-$sffx
    install -p -m644 %module_name%module_ext %buildroot/%module_local_dir/%kversion-%flavour-%krelease-$ver
    [ -e %modesetmodule_name%module_ext ] &&
	install -p -m644 %modesetmodule_name%module_ext %buildroot/%module_local_dir/modeset-%kversion-%flavour-%krelease-$ver
    [ -e %drmmodule_name%module_ext ] &&
	install -p -m644 %drmmodule_name%module_ext %buildroot/%module_local_dir/drm-%kversion-%flavour-%krelease-$ver
    [ -e uvm/%uvmmodule_name%module_ext ] &&
	install -p -m644 uvm/%uvmmodule_name%module_ext %buildroot/%module_local_dir/uvm-%kversion-%flavour-%krelease-$ver
    [ -e %uvmmodule_name%module_ext ] &&
	install -p -m644 %uvmmodule_name%module_ext    %buildroot/%module_local_dir/uvm-%kversion-%flavour-%krelease-$ver
    popd
done
# workaround agains absent uvm module
if ! [ -e %buildroot/%module_local_dir/uvm-%kversion-%flavour-%krelease-%module_version ] ; then
    LAST_UVM_MOD_PATH=`ls -1d %buildroot/%module_local_dir/uvm-* 2>/dev/null | sort -r | head -n1`
    if [ -n "$LAST_UVM_MOD_PATH" ] ; then
	LAST_UVM_MOD_FILE=`basename $LAST_UVM_MOD_PATH`
	ln -s `relative %module_local_dir/$LAST_UVM_MOD_FILE %module_local_dir/uvm-%kversion-%flavour-%krelease-%module_version` %buildroot/%module_local_dir/uvm-%kversion-%flavour-%krelease-%module_version
    else
	ln -s `relative %module_local_dir/%kversion-%flavour-%krelease-%module_version %module_local_dir/uvm-%kversion-%flavour-%krelease-%module_version` %buildroot/%module_local_dir/uvm-%kversion-%flavour-%krelease-%module_version
    fi
fi

echo -n "%module_version" >%buildroot/%nvidia_workdir/%kversion-%flavour-%krelease
ln -s `relative %nvidia_workdir/%kversion-%flavour-%krelease %module_version_dir/%module_name` %buildroot/%module_version_dir/%module_name
ln -s nvidia %buildroot/%module_version_dir/%modesetmodule_name
ln -s nvidia %buildroot/%module_version_dir/%drmmodule_name
ln -s nvidia %buildroot/%module_version_dir/%uvmmodule_name
ln -s `relative %module_local_dir/%kversion-%flavour-%krelease-%module_version         %module_dir/%module_name%module_ext`    %buildroot/%module_dir/%module_name%module_ext
ln -s `relative %module_local_dir/modeset-%kversion-%flavour-%krelease-%module_version %module_dir/%modesetmodule_name%module_ext` %buildroot/%module_dir/%modesetmodule_name%module_ext
ln -s `relative %module_local_dir/drm-%kversion-%flavour-%krelease-%module_version %module_dir/%drmmodule_name%module_ext` %buildroot/%module_dir/%drmmodule_name%module_ext
ln -s `relative %module_local_dir/uvm-%kversion-%flavour-%krelease-%module_version     %module_dir/%uvmmodule_name%module_ext` %buildroot/%module_dir/%uvmmodule_name%module_ext


%post
# switch nvidia driver and libraries
if [ -z "$DURING_INSTALL" ]; then
    if [ "`uname -r`" == "%kversion-%flavour-%krelease" ] ; then
	X11PRESETDRV=`which x11presetdrv 2>/dev/null`
	if [ -n "$X11PRESETDRV" ]; then
	    $X11PRESETDRV ||:
	else
	    echo "Warning! x11presetdrv program not found!" >&2
	fi
    fi
fi

%postun
if [ -z "$DURING_INSTALL" ]; then
    if [ "`uname -r`" == "%kversion-%flavour-%krelease" ] ; then
	X11PRESETDRV=`which x11presetdrv 2>/dev/null`
	if [ -n "$X11PRESETDRV" ]; then
	    $X11PRESETDRV ||:
	else
	    echo "Warning! x11presetdrv program not found!" >&2
	fi
    fi
fi

%files
%defattr(644,root,root,755)
%module_dir
%module_version_dir/%module_name
%module_version_dir/%modesetmodule_name
%module_version_dir/%drmmodule_name
%module_version_dir/%uvmmodule_name
%module_local_dir/%kversion-%flavour-%krelease-*
%module_local_dir/modeset-%kversion-%flavour-%krelease-*
%module_local_dir/drm-%kversion-%flavour-%krelease-*
%module_local_dir/uvm-%kversion-%flavour-%krelease-*
%config(noreplace) %nvidia_workdir/%kversion-%flavour-%krelease

%changelog
