%define rname kapidox

%def_enable python3

Name: kf5-%rname
Version: 5.70.0
Release: alt1
%K5init altplace
%if_disabled python3
%setup_python_module %rname
%endif

Group: System/Libraries
Summary: KDE Frameworks 5 doxygen tools
Url: http://www.kde.org
License: BSD

Requires: kf5-filesystem

Source: %rname-%version.tar

# Automatically added by buildreq on Wed Feb 18 2015 (-bi)
# optimized out: cmake-modules python-base python-modules python-modules-compiler python-modules-email
#BuildRequires: cmake graphviz python-devel python-module-google rpm-build-gir ruby ruby-stdlibs
BuildRequires(pre): rpm-build-kf5
%if_enabled python3
BuildRequires: rpm-build-python3
%else
BuildRequires: rpm-build-python
%endif
BuildRequires: cmake graphviz

%description
This framework contains scripts and data for building API documentation (dox) in
a standard format and style.

%if_enabled python3
%package -n python3-module-%rname
%else
%package -n python-module-%rname
%endif
Group: System/Libraries
Summary: KF5 doxygen tools bindings
#Requires: %name-common = %version-%release
%if_enabled python3
%description -n python3-module-%rname
%else
%description -n python-module-%rname
%endif
KF5 doxygen tools bindings

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.


%prep
%setup -n %rname-%version

%build
%K5build \
%if_enabled python3
    -DPYTHON_EXECUTABLE:PATH=%__python3 \
%else
    -DPYTHON_EXECUTABLE:PATH=%__python \
%endif
    #

%install
%K5install
%K5install_move bin all
%if "%_lib" == "lib64"
mkdir -p %buildroot/%_libdir
mv %buildroot/usr/lib/python* %buildroot/%_libdir/
%endif

%files
%doc LICENSE README.md
%_K5bin/depdiagram-*
%_K5bin/kapidox_generate

%if_enabled python3
%files -n python3-module-%rname
%python3_sitelibdir/kapidox/
%python3_sitelibdir/kapidox-*
%else
%files -n python-module-%rname
%python_sitelibdir/kapidox/
%python_sitelibdir/kapidox-*
%endif

#%files devel
#%_K5inc/kapidox_version.h
#%_K5inc/kapidox/
#%_K5link/lib*.so
#%_K5lib/cmake/kapidox
#%_K5archdata/mkspecs/modules/qt_kapidox.pri

%changelog
