%define rname kconfigwidgets
%def_disable python
%if_enabled python
%define sipver2 %(rpm -q --qf '%%{VERSION}' python-module-sip)
%define sipver3 %(rpm -q --qf '%%{VERSION}' python3-module-sip)
%endif

Name: kf5-%rname
Version: 5.70.0
Release: alt1
%K5init altplace

Group: System/Libraries
Summary: KDE Frameworks 5 widgets for configuration dialogs

Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Source: %rname-%version.tar

# Automatically added by buildreq on Thu Feb 12 2015 (-bi)
# optimized out: cmake cmake-modules docbook-dtds elfutils kf5-kdoctools-devel libEGL-devel libGL-devel libcloog-isl4 libgpg-error libqt5-core libqt5-dbus libqt5-gui libqt5-test libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel python-base ruby ruby-stdlibs xml-common xml-utils
#BuildRequires: docbook-style-xsl extra-cmake-modules gcc-c++ kf5-karchive-devel kf5-kauth-devel kf5-kcodecs-devel kf5-kconfig-devel kf5-kcoreaddons-devel kf5-kdoctools kf5-kdoctools-devel-static kf5-kguiaddons-devel kf5-ki18n-devel kf5-kwidgetsaddons-devel python-module-google qt5-base-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5
%if_enabled python
BuildRequires(pre): python3-module-sip-devel python-module-sip-devel
BuildRequires: python-module-kcodecs-devel python-module-kwidgetsaddons-devel python-module-kconfig-devel python-module-kauth-devel python-module-kcoreaddons-devel
BuildRequires: python-module-PyQt5-devel
%endif
BuildRequires: qt5-base-devel qt5-tools-devel
BuildRequires: docbook-style-xsl extra-cmake-modules
BuildRequires: kf5-karchive-devel kf5-kauth-devel kf5-kcodecs-devel kf5-kconfig-devel
BuildRequires: kf5-kwidgetsaddons-devel kf5-kcoreaddons-devel kf5-kguiaddons-devel kf5-ki18n-devel
BuildRequires: kf5-kdoctools kf5-kdoctools-devel-static

%description
KConfigWidgets provides easy-to-use classes to create configuration dialogs, as
well as a set of widgets which uses KConfig to store their settings.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: kf5-kauth-devel kf5-kcodecs-devel kf5-kconfig-devel kf5-kwidgetsaddons-devel
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5configwidgets
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5configwidgets
KF5 library

%if_enabled python
%package -n python-module-%rname
Summary: Python bindings for KConfigWidgets
License: GPLv2+ / LGPLv2+
Group: Development/Python
Requires: %name-common = %version-%release
Requires: python-module-pykf5
Requires: python-module-sip = %sipver2
%description -n python-module-%rname
Python bindings for KConfigWidgets

%package -n python-module-%rname-devel
Summary: Sip files for python-module-%rname
Group: Development/Python
BuildArch: noarch
%description -n python-module-%rname-devel
Sip files for python-module-%rname

%package -n python3-module-%rname
Summary: Python3 bindings for KConfigWidgets
License: GPLv2+ / LGPLv2+
Group: Development/Python3
Requires: %name-common = %version-%release
Requires: python3-module-pykf5
Requires: python3-module-sip = %sipver3
%description -n python3-module-%rname
Python3 bindings for KConfigWidgets

%package -n python3-module-%rname-devel
Summary: Sip files for python3-module-%rname
Group: Development/Python3
BuildArch: noarch
%description -n python3-module-%rname-devel
Sip files for python3-module-%rname
%endif

%prep
%setup -n %rname-%version

%build
%K5cmake

%install
%K5install
%K5install_move data locale
%find_lang %name --all-name --with-kde
%K5find_qtlang %name --all-name
rm -rf %buildroot%_libdir/*/*/*/__*


mkdir -p %buildroot/%_K5data/kconfigwidgets/


%files common -f %name.lang
%doc COPYING.LIB README.md
%dir %_K5data/kconfigwidgets/
%_datadir/qlogging-categories5/*.*categories
%_K5i18n/*/kf5_entry.desktop

%files devel
%_bindir/preparetips5
%_K5bin/preparetips5
%_K5inc/kconfigwidgets_version.h
%_K5inc/KConfigWidgets/
%_K5link/lib*.so
%_K5lib/cmake/KF5ConfigWidgets
%_K5archdata/mkspecs/modules/qt_KConfigWidgets.pri
%_K5plug/designer/*.so

%files -n libkf5configwidgets
%_K5lib/libKF5ConfigWidgets.so.*

%if_enabled python
%files -n python-module-%rname
%python_sitelibdir/PyKF5/*.so
%files -n python-module-%rname-devel
%_datadir/sip/PyKF5/KConfigWidgets/
%files -n python3-module-%rname
%python3_sitelibdir/PyKF5/*.so
%files -n python3-module-%rname-devel
%_datadir/sip3/PyKF5/KConfigWidgets/
%endif

%changelog
