%define rname kcoreaddons
%def_disable python
%if_enabled python
%define sipver2 %(rpm -q --qf '%%{VERSION}' python-module-sip)
%define sipver3 %(rpm -q --qf '%%{VERSION}' python3-module-sip)
%endif

Name: kf5-%rname
Version: 5.70.0
Release: alt2
%K5init altplace

Group: System/Libraries
Summary: KDE Frameworks 5 Tier 1 addon with various classes on top of QtCore
Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Source: %rname-%version.tar
Patch1: alt-simplify-kde4home.patch
Patch2: alt-kreslimit-integration.patch

# Automatically added by buildreq on Thu Dec 25 2014 (-bi)
# optimized out: cmake cmake-modules elfutils libEGL-devel libGL-devel libcloog-isl4 libqt5-core libqt5-gui libqt5-test libqt5-widgets libqt5-xml libstdc++-devel python-base qt5-base-devel qt5-tools ruby ruby-stdlibs shared-mime-info
#BuildRequires: extra-cmake-modules gcc-c++ python-module-google qt5-tools-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
%if_enabled python
BuildRequires(pre): python3-module-sip-devel python-module-sip-devel
BuildRequires: python-module-PyQt5-devel
%endif
BuildRequires: gcc-c++ extra-cmake-modules qt5-base-devel qt5-tools-devel
BuildRequires: shared-mime-info

%description
KCoreAddons provides classes built on top of QtCore to perform various tasks
such as manipulating mime types, autosaving files, creating backup files,
generating random sequences, performing text manipulations such as macro
replacement, accessing user information and many more.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: qt5-base-devel
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5coreaddons
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5coreaddons
KF5 library

%if_enabled python
%package -n python-module-pykf5
Summary: common package for KF5 python bindings
License: GPLv2+ / LGPLv2+
Group: Development/Python
Requires: %name-common = %version-%release
%description -n python-module-pykf5
common package for KF5 python bindings

%package -n python-module-%rname
Summary: Python bindings for KCoreAddons
License: GPLv2+ / LGPLv2+
Group: Development/Python
Requires: %name-common = %version-%release
Requires: python-module-pykf5
Requires: python-module-sip = %sipver2
%description -n python-module-%rname
Python bindings for KCoreAddons

%package -n python-module-%rname-devel
Summary: Sip files for python-module-%rname
Group: Development/Python
BuildArch: noarch
%description -n python-module-%rname-devel
Sip files for python-module-%rname

%package -n python3-module-pykf5
Summary: common package for KF5 python3 bindings
License: GPLv2+ / LGPLv2+
Group: Development/Python3
Requires: %name-common = %version-%release
%description -n python3-module-pykf5
common package for KF5 python3 bindings

%package -n python3-module-%rname
Summary: Python3 bindings for KCoreAddons
License: GPLv2+ / LGPLv2+
Group: Development/Python3
Requires: %name-common = %version-%release
Requires: python3-module-sip = %sipver3
%description -n python3-module-%rname
Python3 bindings for KCoreAddons

%package -n python3-module-%rname-devel
Summary: Sip files for python3-module-%rname
Group: Development/Python3
BuildArch: noarch
%description -n python3-module-%rname-devel
Sip files for python3-module-%rname
%endif

%prep
%setup -n %rname-%version
%patch1 -p1
%patch2 -p1

%build
%K5build \
    -DKDE4_DEFAULT_HOME=".kde4" \
    -D_KDE4_DEFAULT_HOME_POSTFIX=4 \
    #

%install
%K5install
%find_lang %name --all-name
%K5find_qtlang %name --all-name


%files common -f %name.lang
%doc COPYING.LIB README.md
%_datadir/qlogging-categories5/*.*categories
%_xdgmimedir/packages/kde5.xml
%_K5data/licenses/

%files devel
%_K5bin/desktoptojson
%_K5inc/kcoreaddons_version.h
%_K5inc/KCoreAddons/
%_K5link/lib*.so
%_K5lib/cmake/KF5CoreAddons
%_K5archdata/mkspecs/modules/qt_KCoreAddons.pri

%files -n libkf5coreaddons
%_K5lib/libKF5CoreAddons.so.*

%if_enabled python
%files -n python-module-pykf5
%dir %python_sitelibdir/PyKF5/
%python_sitelibdir/PyKF5/__init__.py*
%dir %_datadir/sip/PyKF5/
%files -n python-module-%rname
%python_sitelibdir/PyKF5/*.so
%files -n python-module-%rname-devel
%_datadir/sip/PyKF5/KCoreAddons/
%files -n python3-module-pykf5
%dir %python3_sitelibdir/PyKF5/
%python3_sitelibdir/PyKF5/__init__.py
%python3_sitelibdir/PyKF5/__pycache__/
%dir %_datadir/sip3/PyKF5/
%files -n python3-module-%rname
%python3_sitelibdir/PyKF5/*.so
%files -n python3-module-%rname-devel
%_datadir/sip3/PyKF5/KCoreAddons/
%endif

%changelog
