# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define majver 5.0

Name: kicad
Summary: An open source software for the creation of electronic schematic diagrams
Summary(ru_RU.UTF-8): Программа с открытым исходным кодом для проектирования электронных схем
Version: 5.1.6
Release: alt1.rc1
Epoch: 1
Packager: Anton Midyukov <antohami@altlinux.org>
License: AGPL-3-or-later
Group: Engineering
Url: https://code.launchpad.net/kicad
#Url: https://github.com/KiCad/kicad-source-mirror.git

Source: %name-%version.tar
Source1: pcbnew.py
Patch1: kicad-5.1.0-nostrip.patch
Patch2: fix-python3.patch

BuildRequires(pre): cmake rpm-macros-cmake
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev
BuildRequires: python3-module-wx
BuildRequires: boost-devel boost-asio-devel boost-asio-devel boost-context-devel boost-filesystem-devel boost-geometry-devel boost-interprocess-devel boost-locale-devel boost-program_options-devel
BuildRequires: ccmake gcc-c++
BuildRequires: libwxGTK3.0-devel
BuildRequires: libGLEW-devel libcairo-devel libssl-devel swig pkgconfig(gobject-2.0) libpcre-devel libpixman-devel pkgconfig(harfbuzz) pkgconfig(expat) pkgconfig(libdrm) pkgconfig(xdmcp) pkgconfig(xdamage) pkgconfig(xxf86vm) libcurl-devel
BuildRequires: doxygen
BuildRequires: dos2unix
BuildRequires: python-devel
BuildRequires: libglm-devel
BuildRequires: libuuid-devel
BuildRequires: ngspice-devel
BuildRequires: OCE-devel
BuildRequires: openmpi-devel
BuildRequires: ImageMagick-tools
BuildRequires: desktop-file-utils
Requires: %name-data = %EVR
#Requires: kicad-packages3D >= %majver
Requires: kicad-symbols >= %majver
Requires: kicad-footprints >= %majver
Requires: kicad-templates >= %majver
Requires: %name-doc >= %epoch:%majver
Requires: %name-i18n >= %majver

%add_python3_path %_datadir/%name

%description
Kicad is an open source (GPL) software for the creation of electronic
schematic diagrams and printed circuit board artwork.

Kicad is a set of four softwares and a project manager:

Kicad: Project manager.
Eeschema: Schematic entry.
Pcbnew: Board editor.
Cvpcb: Footprint selector for components used in the circuit design.
Gerbview: GERBER viewer (photoplotter documents).

%description -l ru_RU.UTF-8
Kicad - это программное обеспечение с открытым исходным кодом для
проектирования электронных схем и получения на их основе печатных плат.

Включает в себя редактор схем, средство трассировки печатных плат,
средства трёхмерного просмотра печатных плат в конечном виде.

Kicad состоит из 5 основных компонентов:

 * kicad — менеджер проектов
 * eeschema — редактор схем
 * pcbnew — редактор печатных плат
 * gerbview — просмотр GERBER
 * cvpcb — выбор мест для компонентов

На заметку:
Для использования рамки ГОСТ необходимо выбрать шаблон
gost_landscape.kicad_wks или gost_portrait.kicad_wks в диалоговом окне
"Настройки страницы" в поле "Файл описания разметки листа".
Стандартные файлы рамки (*.kicad_wks) находятся в %_datadir/kicad/template/.

%package data
Summary: An open source software for the creation of electronic schematic diagrams
Summary(ru_RU.UTF-8): Программа с открытым исходным кодом для проектирования электронных схем
Group: Sciences/Computer science
BuildArch: noarch
Requires: icon-theme-hicolor
Requires: %name = %EVR

%description data
Kicad is an open source (GPL) software for the creation of electronic
schematic diagrams and printed circuit board artwork.

Kicad is a set of four softwares and a project manager:

Kicad: Project manager.
Eeschema: Schematic entry.
Pcbnew: Board editor.
Cvpcb: Footprint selector for components used in the circuit design.
Gerbview: GERBER viewer (photoplotter documents).

Package contains data files.

%description data -l ru_RU.UTF-8
Kicad - это программное обеспечение с открытым исходным кодом для
проектирования электронных схем и получения на их основе печатных плат.

Для использования рамки ГОСТ необходимо выбрать шаблон
gost_landscape.kicad_wks или gost_portrait.kicad_wks в диалоговом окне
"Настройки страницы" в поле "Файл описания разметки листа".
Стандартные файлы рамки (*.kicad_wks) находятся в %_datadir/kicad/template/.

Пакет содержит архитектурно-независимые файлы.

%prep
%setup -n %name-%version
%patch1 -p1
%patch2 -p1

%build    
%cmake \
    -DKICAD_SCRIPTING=ON \
    -DKICAD_SCRIPTING_MODULES=ON \
    -DKICAD_SCRIPTING_WXPYTHON=ON \
    -DKICAD_SCRIPTING_WXPYTHON_PHOENIX=ON \
    -DKICAD_SCRIPTING_PYTHON3=ON \
    -DKICAD_SCRIPTING_ACTION_MENU=ON \
    -DKICAD_SPICE=ON \
    -DKICAD_VERSION_EXTRA=%release \
    -DCMAKE_BUILD_TYPE=Release \
    -DPYTHON_SITE_PACKAGE_PATH=%python3_sitelibdir

%cmake_build

%install
%cmakeinstall_std

# !!!Fix me
# Needed swig4
install -m 755 %SOURCE1 %buildroot%python3_sitelibdir/pcbnew.py

#fix line ending
dos2unix %buildroot%_desktopdir/*.desktop

#validate desktop files
desktop-file-validate %buildroot%_desktopdir/*.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Engineering \
	%buildroot%_desktopdir/kicad.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Engineering \
	%buildroot%_desktopdir/eeschema.desktop

%files
%_bindir/*
%_desktopdir/*.desktop
%_libdir/*.so*
%_libdir/%name/
%python3_sitelibdir/_pcbnew.so
%python3_sitelibdir/pcbnew.py
%python3_sitelibdir/__pycache__/pcbnew*

%files data
%doc %_docdir/%name
%_datadir/appdata/%name.appdata.xml
%_iconsdir/hicolor/*/mimetypes/application-x-*.*
%_iconsdir/hicolor/*/apps/*.*
%_datadir/%name/
%_datadir/mime/packages/*

%changelog
