Name: lapackpp
Version: 2.5.4
Release: alt2.svn20110615
Summary: LAPACK++ is a library for high performance linear algebra computations
License: LGPL v2.1
Group: Sciences/Mathematics
Url: http://lapackpp.sourceforge.net/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://lapackpp.svn.sourceforge.net/svnroot/lapackpp/lapackpp/trunk
Source: %name-%version.tar.gz

BuildPreReq: gcc-fortran liblapack-devel gcc-c++
BuildPreReq: doxygen graphviz

%description
LAPACK++ is a library for high performance linear algebra computations.
This version includes support for solving linear systems using LU,
Cholesky, QR matrix factorizations, for real and complex matrices.

%package -n lib%name
Summary: Shared libraries of LAPACK++
Group: System/Libraries

%description -n lib%name
LAPACK++ is a library for high performance linear algebra computations.
This version includes support for solving linear systems using LU,
Cholesky, QR matrix factorizations, for real and complex matrices.

This package contains shared libraries of LAPACK++.

%package -n lib%name-devel
Summary: Development files of LAPACK++
Group: Development/C++
Requires: lib%name = %version-%release
Requires: liblapack-devel

%description -n lib%name-devel
LAPACK++ is a library for high performance linear algebra computations.
This version includes support for solving linear systems using LU,
Cholesky, QR matrix factorizations, for real and complex matrices.

This package contains development files of LAPACK++.

%package -n lib%name-devel-doc
Summary: Documentation for LAPACK++
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
LAPACK++ is a library for high performance linear algebra computations.
This version includes support for solving linear systems using LU,
Cholesky, QR matrix factorizations, for real and complex matrices.

This package contains development documentation for LAPACK++.

%prep
%setup

%build
./autogen.sh
%configure \
	--with-lapackpp-prefix=%prefix \
	--with-blas=openblas
%make_build

%make_build -C testing tCmplxSolve tEigSolve tGenSolve tSpdSolve tSymmSolve

doxygen

%install
%makeinstall_std

%check
pushd testing
./lapack++_test
popd

%files -n lib%name
%doc AUTHORS COPYING ChangeLog NEWS README
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_aclocaldir/*

%files -n lib%name-devel-doc
%doc api-doc/html/*

%changelog
