%define cfg %_builddir/%name-%version/
# See https://svn.freepascal.org/svn/lazarus/tags/lazarus_2_0_2/ for example
%define rev 63942

Name:    lazarus
Version: 2.0.12
Release: alt1
Epoch:   1

Summary: Lazarus Component Library and IDE
License: GPL-2.0 and LGPL-2.0 and MPL-1.1
Group:   Development/Other
Url:     http://www.lazarus-ide.org/

Packager: Andrey Cherepanov <cas@altlinux.org>

ExclusiveArch: %ix86 x86_64 aarch64

Source:  %name-%version.tar
Source2: extra.tar
Source3: environmentoptions.xml
Source4: projectoptions.xml

Patch0: %name-0.9.22-alt-relax-onwine.patch
Patch1: %name-without-tests.patch
Patch2: %name-fix-desktop-file.patch
Patch3: %name-fix-install-path-in-Makefile.patch
Patch4: %name-2.0.2-fix-fpc-search.patch
Patch6:	%name-set-user-TestBuildDirectory.patch

# Patches from Debian
Patch11: lazarus-default-config.patch
Patch12: lazarus-lcl-with-multple-widget-sets.patch

# Other patches
Patch13: lazarus-customform-sigsegv-fix.patch

# Upstream fixes

BuildRequires(pre): qt5-base-devel
BuildRequires: fpc >= 2.6.4 fpc-utils glibc-devel libgtk+2-devel libXi-devel desktop-file-utils 
BuildRequires: libXext-devel libXtst-devel libGL-devel libGLU-devel libode-devel
BuildRequires: qt5-x11extras-devel
BuildRequires: qt5pas-devel

Requires:   fpc >= 2.6.4 fpc-src fpc-utils gdb libGL-devel libXi-devel libXext-devel libgtk+2-devel
Requires:   glibc-devel
Requires:   libdbus-devel
Requires:   xterm
Requires:   lazarus-lcl
# Default LCL
Requires:   lazarus-gtk

Provides:   %name-docs = %version
Obsoletes:  %name-docs < %version
Provides:   %name-examples = %version
Obsoletes:  %name-examples < %version

%add_findreq_skiplist %_libdir/%name/examples/* %_libdir/%name/components/*

%description
Lazarus is a free and open source Rapid Application Development tool
for the FreePascal compiler using the Lazarus component library - LCL.
The LCL is included in this package.

%description -l ru_RU.UTF8
Lazarus - свободно-распространяемая, с открытым исходным кодом,
среда для быстрой разработки прикладных программ (Rapid Application
Development tool) на FreePascal, использующая библиотеки компонет LCL
(Lazarus component library).  LCL входят в состав данного пакета.

%package qt5
Summary: Interface for Lazarus based on Qt5
Group: Development/Other
Provides: lazarus-lcl
Requires: qt5pas-devel

%description qt5
Interface for Lazarus based on Qt5.

%package gtk
Summary: Interface for Lazarus based on GTK+
Group: Development/Other
Provides: lazarus-lcl

%description gtk
Interface for Lazarus based on GTK+.

# The version is taken from lcl/interfaces/qt5/cbindings/Qt5Pas.pro
%global qt5pas_version 2.6
%global qt5pas_release alt1
%package -n qt5pas
Version: %qt5pas_version
Release: %qt5pas_release
Summary: Qt5 bindings for Pascal
Group:   Development/Other

%description -n qt5pas
Qt5 bindings for Pascal from Lazarus.

%package -n qt5pas-devel
Version: %qt5pas_version
Release: %qt5pas_release
Summary: Development files for qt5pas
Group:   Development/Other
Requires: qt5pas = %qt5pas_version-%qt5pas_release

%description -n qt5pas-devel
The qt5pas-devel package contains libraries and header files for
developing applications that use qt5pas.

%prep
%setup
%patch0 -p1

tar xf %SOURCE2
%patch1 -p2
%patch2 -p2
%patch3 -p2
subst 's|/usr/lib/|%{_libdir}/|' %PATCH4
%patch4 -p2
%patch6 -p2
%patch11 -p1
%patch12 -p1
%patch13 -p2

install -D -p -m 0644 %SOURCE3 tools/install/linux/environmentoptions.xml
#sed -i -e 's,@version@,%version,g' tools/install/linux/helpoptions.xml docs/index.ru.html

# Replace xterm call with real path
find . -name *.lpi -print0 -o -name *.kof -print0 | xargs -0 -L 1 subst 's,[\\/]usr[\\/]\(X11R6[\\/]\)\?bin[\\/]\(xterm\|gnome-terminal\),/usr/bin/xterm,'

# Install to %%_libdir instead of %%_datadir because lasarus dir contains binaries
subst 's|share/lazarus|%_lib/lazarus|' Makefile

%build
MAKEOPTS="-Fl/opt/gnome/lib"
if [ -n "$FPCCfg" ]; then
  MAKEOPTS="$MAKEOPTS -n @$FPCCfg"
fi
#CHMHELP:MAKEOPTS="$MAKEOPTS -dUseCHMHelp"

# Put SVN revision into revision.inc
echo "const RevisionStr = '%rev';" > ide/revision.inc

# Make IDE
# Build IDE based on Qt5
make bigide OPT="$MAKEOPTS" USESVN2REVISIONINC=0 LCL_PLATFORM=qt5
mv lazarus lazarus-qt5

# Build IDE based on GTK+
make bigide OPT="$MAKEOPTS" USESVN2REVISIONINC=0 LCL_PLATFORM=gtk2
cp lazarus lazarus-gtk

# Make other program and utilites
sed -e "s#__LAZARUSDIR__#%{cfg}#" tools/install/linux/environmentoptions.xml > environmentoptions.xml

%ifnarch aarch64
# Build apiwizz
make -C tools/apiwizz/
%endif

# Build explorateur_lrs
./lazbuild --ws="$LCL_PLATFORM" --pcp=%cfg tools/explorateur_lrs/LRS_Explorer.lpr
mv tools/explorateur_lrs/release/* tools/explorateur_lrs
rm -rf tools/explorateur_lrs/release/

# Build lazdatadesktop
mkdir -p tools/lazdatadesktop/lib
./lazbuild --ws="$LCL_PLATFORM" --pcp=%cfg tools/lazdatadesktop/lazdatadesktop.lpr

# Generate documentation
export LCL_PLATFORM=nogui
./lazbuild --ws="$LCL_PLATFORM" --pcp=%cfg docs/html/build_lcl_docs.lpi
pushd docs/html
./build_lcl_docs
./build_html.sh
popd

# Build Qt5 bindings
pushd lcl/interfaces/qt5/cbindings/
    %qmake_qt5
    %make_build
popd

export LCL_PLATFORM=
#export LCL_PLATFORM=gtk2
#export FPCDIR=%%_libdir/fpc
strip lazarus-qt5
strip lazarus-gtk
strip startlazarus
strip lazbuild
strip tools/lazres
strip tools/updatepofiles
strip tools/lrstolfm
strip tools/svn2revisioninc
if [ -f components/chmhelp/lhelp/lhelp ]; then
  strip components/chmhelp/lhelp/lhelp
fi

rm -f environmentoptions.xml

%install
LAZARUSDIR=%_libdir/%name
mkdir -p %buildroot$LAZARUSDIR \
         %buildroot%_sysconfdir/%name
%makeinstall_std INSTALL_PREFIX=%buildroot%_prefix _LIB=%_lib
install -m 644 install/lazarus.desktop %buildroot%_desktopdir/%name.desktop

install -Dm0755 lazarus-qt5 %buildroot%_bindir/lazarus-qt5
install -Dm0755 lazarus-gtk %buildroot%_bindir/lazarus-gtk
rm -f %buildroot%_bindir/lazarus-ide
mkdir -p %buildroot%_altdir
echo "%_bindir/lazarus	%_bindir/lazarus-qt5	50" > %buildroot%_altdir/lazarus-qt5
echo "%_bindir/lazarus	%_bindir/lazarus-gtk	100" > %buildroot%_altdir/lazarus-gtk

ln -sf $LAZARUSDIR/tools/explorateur_lrs/LRS_Explorer %buildroot%_bindir/LRS_Explorer
ln -sf $LAZARUSDIR/tools/explorateur_lrs/LRS_Explorer %buildroot%_bindir/lrsexplorer
%ifnarch aarch64
ln -sf $LAZARUSDIR/tools/apiwizz/apiwizz %buildroot%_bindir/apiwizz
%endif
ln -sf $LAZARUSDIR/tools/lazdatadesktop/lazdatadesktop %buildroot%_bindir/lazdatadesktop

cat tools/install/linux/environmentoptions.xml | sed -e "s#__LAZARUSDIR__#$LAZARUSDIR/#" -e "s#__FPCSRCDIR__#%{_datadir}/fpcsrc/#" > %buildroot%_sysconfdir/%name/environmentoptions.xml

# fix bug 13256
mkdir -p %buildroot%_datadir/fpcsrc/packages/fcl-base
mkdir -p %buildroot%_datadir/fpcsrc/rtl/inc

# fix navigate to line with error (see https://bugs.altlinux.org/25991#c20)
install -D -p -m 0644 %SOURCE4 %buildroot%_sysconfdir/lazarus/projectoptions.xml
subst 's|/usr/lib/|%{_libdir}/|' %buildroot%_sysconfdir/lazarus/projectoptions.xml

# Docs
test -e docs/index.en.html || mv docs/index.html docs/index.en.html

# Install CHM files to doc dir
cp -a docs/chm/* %buildroot$LAZARUSDIR/docs/html/

# cleanup installation
rm -rf %buildroot$LAZARUSDIR/tools/install
rm -rf %buildroot$LAZARUSDIR/tools/find_merged_revisions.pas

# generate correct compilertest.pas
echo -e "begin\nend." > %buildroot$LAZARUSDIR/compilertest.pas

pushd lcl/interfaces/qt5/cbindings/
    %makeinstall_std INSTALL_ROOT=%buildroot
popd
rm -rf %buildroot$LAZARUSDIR/lcl/interfaces/qt5/cbindings
rm -rf %buildroot$LAZARUSDIR/lazarus.app

# Make executable symlink to selected program
rm -f %buildroot$LAZARUSDIR/lazarus
ln -s ../../bin/lazarus %buildroot$LAZARUSDIR/lazarus

%files
%_libdir/%name
%_bindir/*
%exclude %_bindir/lazarus-qt5
%exclude %_bindir/lazarus-gtk
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/environmentoptions.xml
%config(noreplace) %_sysconfdir/%name/projectoptions.xml
%_pixmapsdir/lazarus.png
%_desktopdir/lazarus.desktop
%_datadir/mime/packages/lazarus.xml
%_man1dir/*
# fix bug 13256
%dir %_datadir/fpcsrc/rtl/inc
%dir %_datadir/fpcsrc/packages/fcl-base
%exclude %_libdir/libQt5Pas.so*
%_iconsdir/hicolor/48x48/mimetypes/*.png

%files qt5
%_bindir/lazarus-qt5
%_altdir/lazarus-qt5

%files gtk
%_bindir/lazarus-gtk
%_altdir/lazarus-gtk

%files -n qt5pas
%doc lcl/interfaces/qt5/cbindings/COPYING.TXT
%doc lcl/interfaces/qt5/cbindings/README.TXT
%_libdir/libQt5Pas.so.*

%files -n qt5pas-devel
%_libdir/libQt5Pas.so

%changelog
