Name: leafnode
Version: 1.11.11
Release: alt1

Summary: a leafsite NNTP server
License: Artistic
Group: System/Servers

Url: http://www.leafnode.org
Source0: ftp://wpxx02.toxi.uni-wuerzburg.de/pub/%{name}-%{version}.tar.xz
Source1: %name.texpire
Source2: %name.filters
Source3: %name.xinetd
Source4: %name.watch
Packager: Michael Shigorin <mike@altlinux.org>

Summary(ru_RU.UTF-8): небольшой NNTP-сервер
Summary(uk_UA.UTF-8): невеличкий NNTP-сервер

# NOTE: buildreq would catch %%_sbindir/tcpd from and add tcp_wrappers :-/
# So don't run that on this. -- mike

BuildRequires: libpcre-devel
Conflicts: inn cyrus-imapd

%define nntp_server news.talk.ru
%define leafgroup news
%define leafuser news

%description
Leafnode is a small NNTP server for leaf sites without permanent
connection to the internet. It supports a subset of NNTP and is able to
automatically fetch the newsgroups the user reads regularly from the
newsserver of the ISP and push the posted messages.

%description -l ru_RU.UTF-8
Leafnode - небольшой NNTP-сервер для "домашних" новостей при отсутствии
постоянного соединения с Internet.  Он поддерживает подмножество NNTP
и позволяет автоматически доставлять группы новостей и отправлять
сообщения при помощи news-сервера провайдера.

%description -l uk_UA.UTF-8
Leafnode - невеличкий NNTP-сервер для "домашн╕х" новин за в╕дсутност╕
пост╕йного з'╓днання з Internet.  В╕н п╕дтриму╓ п╕дмножину NNTP та
дозволя╓ автоматично приймати групи новин та в╕дсилати листи за
допомогою news-серверу провайдера.

%prep
%setup

%build
%configure \
	--sysconfdir=%_sysconfdir/%name \
	--with-spooldir=%_spooldir/news \
	--with-lockfile=%_lockdir/news/fetchnews.lck
%make_build

%install
install -d %buildroot%_sysconfdir/{cron.daily,leafnode}
# carefully working around horrors in Makefile...
%makeinstall_std \
        prefix=%buildroot%prefix \
	SPOOLDIR=%_spooldir/news \
	LOCKFILE=%buildroot%_lockdir/news/fetchnews.lck

install -pDm600 filters.example %buildroot%_sysconfdir/leafnode/filters
install -pDm755 %SOURCE1 %buildroot%_sysconfdir/cron.daily/texpire
install -pDm644 %SOURCE3 %buildroot%_sysconfdir/xinetd.d/%name

sed \
	-e 's,news.hiof.no,%nntp_server,g' \
	-e 's,^# maxfetch,maxfetch,g' \
	-e 's,^# initialfetch,initialfetch,g' \
	-e 's,^# allow_8bit_headers,allow_8bit_headers,g' \
	< config.example \
	> %buildroot%_sysconfdir/leafnode/config

%post
# get hostname to config -- works for first time
grep -qF host.domain.country %_sysconfdir/%name/config && {
	SERVERNAME=`hostname`
	[ -z "$SERVERNAME" ] && SERVERNAME="localhost"
	TMP=`mktemp -q leafnode-config-XXXXXXXXXX`
	[ $? = 0 ] && sed -e "s,host.domain.country,$SERVERNAME,g" \
		< %_sysconfdir/%name/config \
		> $TMP && \
		cat $TMP > %_sysconfdir/%name/config && rm $TMP
} || :

# force spool perms in case of upgrade (since 1.9.38-alt1)
chown -R %leafuser.%leafgroup %_spooldir/news/
chmod -R u=rwX,go=rX %_spooldir/news/

# NB:
# - we don't need run.*.dist examples -- using xinetd
# - the same with nntp.rules.dist

# TODO
# - use %leafgroup for texpire?
# - config dir should be better guarded probably? (or not?)

%files
%_mandir/man?/*
%doc ADD-ONS CREDITS INSTALL KNOWNBUGS NEWS *README* FAQ.html FAQ.txt
%doc tools/archivefaq.pl update.sh
%dir %_sysconfdir/%name/
%config(noreplace) %verify(not size mtime md5) %_sysconfdir/xinetd.d/%name
%attr(755,root,root) %config(noreplace) %_sysconfdir/cron.daily/texpire
%attr(640,root,%leafgroup) %config(noreplace) %_sysconfdir/%name/config
%attr(640,root,%leafgroup) %config(noreplace) %_sysconfdir/%name/filters
%attr(710,root,%leafgroup) %_sbindir/*
%attr (775,root,%leafgroup) %_lockdir/news
%attr (755,%leafuser,%leafgroup) %_spooldir/news
%_bindir/*

%changelog
