%def_disable static

Name: libEMF
Version: 1.0.11
Release: alt1

Summary: A library for generating Enhanced Metafiles
License: LGPLv2+ and GPLv2+
Group: System/Libraries

Url: http://libemf.sourceforge.net
Source0: http://downloads.sourceforge.net/libemf/libemf-%version.tar.gz
Source1: libEMF.watch
Patch: libEMF-aarch64.patch
Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Sun Dec 13 2009
BuildRequires: gcc-c++

Summary(pl): Biblioteka do generowania plików w formacie Enhanced Metafile

%description
libEMF is a library for generating Enhanced Metafiles on systems which
don't natively support the ECMA-234 Graphics Device Interface
(GDI). The library is intended to be used as a driver for other
graphics programs such as Grace or gnuplot. Therefore, it implements a
very limited subset of the GDI.

%description -l pl
libEMF to biblioteka do generowania plików w formacie Enhanced
Metafile na systemach nie obsługujących natywnie systemu graficznego
ECMA-234 GDI. Biblioteka ma służyć jako sterownik dla innych programów
graficznych, takich jak Grace czy gnuplot. Z tego powodu ma
zaimplementowany bardzo ograniczony podzbiór GDI.

%package utils
Summary: libEMF utilities
Group: File tools

%description utils
libEMF utilities

%package devel
Summary: libEMF header files
Summary(pl): Pliki nagłówkowe libEMF
Group: Development/C++
Requires: %name = %version-%release
Requires: libstdc++-devel

%description devel
libEMF header files.

%description devel -l pl
Pliki nagłówkowe libEMF.

%if_enabled static
%package devel
Summary: libEMF static files
Group: Development/C++
Requires: %name = %version-%release
Requires: libstdc++-devel

%description devel-static
libEMF static files.
%endif

%prep
%setup -n libemf-%version
%patch -p1 -b .aarch64

%build
%autoreconf
%configure %{subst_enable static} --enable-editing
%make_build

%install
export CPPROG="cp -p"
%makeinstall_std

%check
make check

%files
%doc AUTHORS ChangeLog COPYING COPYING.LIB NEWS README
%_libdir/lib*.so.*

%files utils
%_bindir/*

%files devel
%doc doc/html
%_libdir/lib*.so
%_includedir/%name/

%if_enabled static
%files devel-static
%_libdir/lib*.a
%endif

%changelog
