%define shortname SDL_pango

Name: lib%shortname
Version: 0.1.2
Release: alt5

Summary: Rendering of internationalized text for SDL (Simple DirectMedia Layer)
License: LGPL
Group: System/Libraries
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Url: http://sdlpango.sourceforge.net/

Source0: http://dl.sf.net/sdlpango/%shortname-%version.tar.bz2
Source1: doxygen.png

Patch0: SDL_Pango-0.1.2-suppress-warning.patch
Patch1: SDL_Pango-0.1.2-API-adds.patch

BuildRequires: libpango-devel libSDL-devel dos2unix

%description
Pango is the text rendering engine of GNOME 2. SDL_Pango connects that engine
to SDL, the Simple DirectMedia Layer.

%package -n lib%shortname-devel
Summary: Development files for SDL_pango
Group: Development/C
Requires: lib%shortname = %version-%release
#, pango-devel, SDL-devel, pkgconfig

%description -n lib%shortname-devel
Development files for SDL_Pango.

%prep
%setup -q -n %shortname-%version
%patch0 -p1 -b .suppress-warning
%patch1 -p1 -b .API-adds

# Clean up, we include the entire "docs/html" content for the devel package
%__rm -rf docs/html/CVS/

# Replace the corrupt doxygen.png file with a proper one
%__install -m 0644 -p %SOURCE1 docs/html/doxygen.png

# Fix the (many) DOS encoded files, not *.png since they get corrupt
find . -not -name \*.png -type f -exec dos2unix {} \;

%build
%autoreconf
libtoolize --copy --force

%configure --disable-static
%make

%install
%make_install DESTDIR="%buildroot" install

%files -n lib%shortname
%doc AUTHORS ChangeLog COPYING NEWS README
%_libdir/*.so.*

%files -n lib%shortname-devel
%doc docs/html/*
%_includedir/SDL_Pango.h
%_libdir/pkgconfig/SDL_Pango.pc
%_libdir/*.so

%changelog
