%def_disable   static
%def_disable   doc
%def_enable    ruby
%def_disable   python

Name:          libcaca
Version:       0.99
Release:       alt19.git813baea7a
Summary:       Text mode graphics library
Group:         System/Libraries
License:       DWTFYWTPL
Url:           http://sam.zoy.org/projects/libcaca/
Vcs:           https://github.com/cacalabs/libcaca.git

Source:        %name-%version.tar
BuildRequires: gcc-c++ imake imlib2-devel libncurses-devel libslang2-devel xorg-cf-files zlib-devel
%if_enabled    ruby
BuildRequires(pre): rpm-build-ruby
%endif
%if_enabled    python
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
%endif
%if_enabled    doc
# buildreqs drowns in loops and misses all latex stuff
BuildRequires: doxygen
BuildRequires: texmf-latex-tabu
BuildRequires: tex-common texlive-base texlive-base-bin texlive-common
BuildRequires: texlive-fonts-recommended texlive-generic-recommended
BuildRequires: texlive-latex-base texlive-latex-recommended
BuildRequires: texlive-publishers texlive-xetex texmf-latex-xcolor
%endif

%description
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

%package       devel
Summary:       Development files for libcaca
Group:         Development/C
Requires:      %name = %version-%release

%description   devel
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

This package contains the header files and static libraries needed to
compile applications or shared objects that use libcaca.

%package       -n caca-utils
Summary:       Text mode graphics utilities
Group:         Graphics
Requires:      %name = %version-%release

%description   -n caca-utils
This package contains utilities and demonstration programs for libcaca, the
Colour AsCii Art library.

cacaview is a simple image viewer for the terminal. It opens most image
formats such as JPEG, PNG, GIF etc. and renders them on the terminal using
ASCII art. The user can zoom and scroll the image, set the dithering method
or enable anti-aliasing.

cacaball is a tiny graphic program that renders animated ASCII metaballs on
the screen, cacafire is a port of AALib's aafire and displays burning ASCII
art flames, cacamoir animates colourful moire circles and cacaplas displays
an old school plasma effect.

cacademo is a simple application that shows the libcaca rendering features
such as line and ellipses drawing, triangle filling and sprite blitting.

%if_enabled    ruby
%package       -n ruby-libcaca
Summary:       Ruby bindings for libcaca
Group:         Graphics
Requires:      %name = %version-%release
Provides:      ruby-module-libcaca
Obsoletes:     ruby-module-libcaca

%description   -n ruby-libcaca
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

This package contains Ruby bindings for libcaca.
%endif

%if_enabled    python
%package       -n python3-module-caca
Summary:       Python module bindings for libcaca
Group:         Other
BuildArch:     noarch
Requires:      %name = %version

%description   -n python3-module-caca
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

This package contains python3 module bindings for libcaca.
%endif


%prep
%setup
find -name '*.py' | while read f; do sed "s,/usr/bin/env python,/usr/bin/env python3," -i $f; done

%build
touch ChangeLog
%autoreconf
%configure \
	--enable-slang \
	--enable-ncurses \
	--enable-x11 \
	--enable-imlib2 \
	--x-libraries=%_x11libdir \
	--disable-debug \
	%{subst_enable doc} \
	%{subst_enable static}

%make_build

%install
%makeinstall_std
rm %buildroot%_libdir/*.la
%if_enabled    doc
rm -r %buildroot%_man3dir
rm -f %buildroot%_docdir/libcucul-dev
mv %buildroot%_datadir/doc/%name-dev %buildroot%_docdir/%name-%version
%endif

%files
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_bindir/caca-config
%_includedir/*
%_pkgconfigdir/*
%if_enabled    doc
%_docdir/%name-%version
%endif
%_man1dir/caca-config.1*

%files         -n caca-utils
%_bindir/cacademo
%_bindir/cacafire
%_bindir/cacaclock
%_bindir/cacaplay
%_bindir/cacaserver
%_bindir/cacaview
%_bindir/img2txt
%_datadir/%name
%_man1dir/cacademo.1*
%_man1dir/cacafire.1*
%_man1dir/cacaplay.1*
%_man1dir/cacaserver.1*
%_man1dir/cacaview.1*
%_man1dir/img2txt.1*

%if_enabled    ruby
%files         -n ruby-libcaca
%ruby__sitelibdir/caca.rb
%ruby_sitearchdir/caca.*
%endif

%if_enabled    python
%doc README
%python3_sitelibdir_noarch/*
%endif

%changelog
