%def_disable snapshot

%define _name champlain
%define ver_major 0.12
%define api_ver 0.12
%def_enable introspection
%def_enable vala
%def_enable gtk_doc
%def_disable memphis
%def_enable demos
%def_enable check

Name: lib%_name
Version: %ver_major.19
Release: alt1

Summary: Map view library for Clutter
License: LGPLv2+
Group: System/Libraries
Url: https://wiki.gnome.org/Projects/%name

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.38
%define cairo_ver 1.4
%define gtk_ver 3.0.1
%define clutter_ver 1.24
%define soup_ver 2.42
%define gir_ver 0.10.3
%define memphis_ver 0.2.1

BuildRequires(pre): meson
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libcairo-devel >= %cairo_ver
BuildRequires: libclutter-devel >= %clutter_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: libclutter-gtk3-devel libsoup-devel libsqlite3-devel gtk-doc
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_memphis:BuildRequires: libmemphis-devel >= %memphis_ver}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.9.5 libgtk+3-gir-devel libclutter-gir-devel %{?_enable_memphis:libmemphis-gir-devel}}

%description
Libchamplain is a C library aimed to provide a ClutterActor to display
rasterized maps.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development files for %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version
Obsoletes: %name-gtk3-devel-doc < 0.12.17
Provides: %name-gtk3-devel-doc = %version-%release

%description devel-doc
This package contains development documentation for %name and %name-gtk
libraries.

%package gtk3
Summary: Gtk+ widget wrapper for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gtk3
Libchamplain-gtk is a library providing a GtkWidget to embed %name
into Gtk+ applications.

%package gtk3-devel
Summary: Development files for %name-gtk
Group: Development/C
Requires: %name-gtk3 = %version-%release
Requires: %name-devel = %version-%release
Obsoletes: %name-vala
Provides: %name-vala = %version-%release

%description gtk3-devel
This package contains development files for %name-gtk.

%package gtk3-devel-doc
Summary: Development documentation for %name-gtk
Group: Development/C
BuildArch: noarch
Conflicts: %name-gtk3 < %version

%description gtk3-devel-doc
This package contains development documentation for %name-gtk.

%package gir
Summary: GObject introspection data for the Libchamplain library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Libchamplain library

%package gir-devel
Summary: GObject introspection devel data for the Libchamplain library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Libchamplain library

%package gtk3-gir
Summary: GObject introspection data for the Libchamplain library
Group: System/Libraries
Requires: %name-gtk3 = %version-%release
Requires: %name-gir = %version-%release

%description gtk3-gir
GObject introspection data for the Libchamplain library

%package gtk3-gir-devel
Summary: GObject introspection devel data for the Libchamplain library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-gtk3-gir = %version-%release
Requires: %name-gir-devel = %version-%release

%description gtk3-gir-devel
GObject introspection devel data for the Libchamplain library

%prep
%setup -n %name-%version

%build
%meson \
	%{?_enable_gtk_doc:-Dgtk_doc=true} \
	%{?_disable_vala:-Dvapi=false} \
	%{?_disable_introspection:-Dintrospection=false} \
	%{?_enable_demos:-Ddemos=true} \
	%{?_enable_memphis:-Dmemphis=true}
%meson_build

%install
%meson_install

%check
LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_libdir/%name-%api_ver.so.*
%doc AUTHORS ChangeLog NEWS

%files devel
%_libdir/%name-%api_ver.so
%dir %_includedir/%_name-%api_ver
%_includedir/%_name-%api_ver/%_name
%_pkgconfigdir/%_name-%api_ver.pc
%{?_enable_vala:%_vapidir/%_name-%api_ver.*}
%doc demos/animated-marker.c
%doc demos/launcher.c
%doc demos/polygons.c

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name-%ver_major/
%endif

%files gtk3
%_libdir/%name-gtk-%api_ver.so.*

%files gtk3-devel
%_libdir/%name-gtk-%api_ver.so
%_includedir/%_name-%api_ver/%_name-gtk
%_pkgconfigdir/%_name-gtk-%api_ver.pc
%{?_enable_vala:%_vapidir/%_name-gtk-%api_ver.*}
%doc demos/launcher-gtk.c
%doc demos/markers.c

%if_enabled gtk_doc
#%files gtk3-devel-doc
#%_datadir/gtk-doc/html/%name-gtk-%ver_major/
%endif

%if_enabled introspection
%files gir
%_typelibdir/Champlain-%api_ver.typelib

%files gtk3-gir
%_typelibdir/GtkChamplain-%api_ver.typelib

%files gir-devel
%_girdir/Champlain-%api_ver.gir

%files gtk3-gir-devel
%_girdir/GtkChamplain-%api_ver.gir
%endif

%changelog
