# If you need to bootstrap this, turn this on.
# Otherwise, you have a loop with libcxxabi
%def_with bootstrap

Name: libcxx
Version: 7.0.0
Release: alt1

Summary: C++ standard library targeting C++11

License: MIT or NCSA
Group: System/Libraries
Url: http://libcxx.llvm.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: http://llvm.org/releases/%version/libcxx-%version.src.tar.xz
Source: %name-%version.tar

BuildRequires: clang llvm-devel cmake llvm-devel-static

%if_with bootstrap
%add_verify_elf_skiplist %_libdir/libc++.so.1.0
# make cmake compiler test happy
BuildRequires: libstdc++-devel
%else
BuildRequires: libcxxabi-devel
BuildRequires: python3
%endif

%description
libc++ is a new implementation of the C++ standard library, targeting C++11.

%package devel
Summary: Headers and libraries for libcxx devel
Requires: %name = %EVR
Group: System/Libraries
%if_without bootstrap
Requires: libcxxabi-devel
%endif

%description devel
%summary.

%package static
Group: System/Libraries
Summary: Static libraries for libcxx
Requires: %name-devel = %EVR

%description static
%summary.

%prep
%setup

%build

# Clang doesn't support these options
%remove_optflags -frecord-gcc-switches

%if_with bootstrap
export LDFLAGS="-Wl,--build-id"
%else
export LDFLAGS="-Wl,--build-id -stdlib=libc++"
%endif
# Clang in older releases than f24 can't build this code without crashing.
# So, we use gcc there. But the really old version in RHEL 6 works. Huh.
%cmake \
	-DCMAKE_C_COMPILER=%_bindir/clang \
	-DCMAKE_CXX_COMPILER=%_bindir/clang++ \
	-DLLVM_CONFIG=%_bindir/llvm-config \
%if_without bootstrap
	-DLIBCXX_CXX_ABI=libcxxabi \
	-DLIBCXX_CXX_ABI_INCLUDE_PATHS=%_includedir \
	-DPYTHONINTERP_FOUND=ON \
	-DPYTHON_EXECUTABLE=%_bindir/python3 \
	-DLIBCXX_ENABLE_ABI_LINKER_SCRIPT=ON \
%endif
%if %_lib == "lib64"
	-DLIBCXX_LIBDIR_SUFFIX:STRING=64 \
%endif
	-DCMAKE_BUILD_TYPE=RelWithDebInfo

%cmake_build

%install
%cmakeinstall_std

%files
%doc LICENSE.TXT
%doc CREDITS.TXT TODO.TXT
%_libdir/libc++.so.*

%files devel
%_includedir/c++/
%_libdir/libc++.so

%files static
%doc LICENSE.TXT
%_libdir/libc++*.a

%changelog
