Name: libdrm
Version: 2.4.105
Release: alt2
Epoch: 1
Summary: Userspace interface to kernel DRM service
License: GPL
Group: System/Libraries
Url: http://dri.freedesktop.org
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires(pre): meson
BuildRequires: docbook-style-xsl libudev-devel libpciaccess-devel xorg-util-macros xsltproc python-module-docutils

%description
This library implements the userspace interface to the kernel DRM
services. DRM stands for "Direct Rendering Manager", which is the
kernelspace portion of the "Direct Rendering Infrastructure" (DRI).
The DRI is currently used on Linux to provide hardware-accelerated
OpenGL drivers

%package devel
Summary: The drm Library and Header Files
Group: Development/C

%description devel
%name-devel contains the libraries and header files needed to
develop programs which make use of %name

%prep
%setup -q
%patch -p1

%build
%meson \
	-Dudev=true \
%ifarch armh aarch64
	-Detnaviv=true \
	-Dexynos=true \
	-Domap=true \
	-Dtegra=true \
	-Dvc4=true \
	-Dfreedreno=true
%endif

%meson_build -v

%install
%meson_install

%files
%_libdir/*.so.*
%_datadir/%name

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man3dir/*.3*
%_man7dir/*.7*

%changelog
