%define _unpackaged_files_terminate_build 1

Name: libffado
Version: 2.4.1
Release: alt2

Summary: Free firewire audio driver library
License: GPLv2+
Group: Sound

Url: http://www.ffado.org/
Source: %name-%version.tar
Patch: libffado-2.0-alt.patch

%setup_python_module ffado

BuildRequires: gcc-c++
BuildRequires: libdbus-devel libexpat-devel libiec61883-devel libxml++2-devel
BuildRequires: python-module-PyQt4 python-module-dbus python-modules-encodings
BuildRequires: scons xdg-utils libconfig-c++-devel

%description
The FFADO project aims to provide a generic, open-source solution for the
support of FireWire based audio devices for the Linux platform. It is the
successor of the FreeBoB project.

%package devel
Summary: Free firewire audio driver library development headers
Group: Development/C
Requires: %name = %EVR

%description devel
Development files needed to build applications against libffado.

%package -n ffado
Summary: Free firewire audio driver library applications and utilities
Group: Sound
Requires: %name = %EVR

%description -n ffado
Applications and utilities for use with libffado.

%package -n %packagename
Summary: Python bindings for %name, %summary
Group: Development/Python
Buildarch: noarch

%description -n  %packagename
Python bindings for %name, %summary

%prep
%setup
%patch -p2
cp -at admin/ -- /usr/share/gnu-config/config.guess

# XXX this uses non-existing module and is not used itself!
rm support/mixer-qt4/ffado/mixer/nodevice.py

# We don't want to install all tests
sed -i '/Install/d' tests/{,*/}SConscript

%build
[ -n "$NPROCS" ] || NPROCS=%__nprocs;
scons -j$NPROCS \
	PREFIX=%prefix \
	LIBDIR=%_libdir \
	WILL_DEAL_WITH_XDG_MYSELF=YES \
	CFLAGS='%optflags' \
	CXXFLAGS='%optflags' \
	CUSTOM_ENV=True \
	MANDIR=%_mandir \

%install
scons \
	PREFIX=%prefix \
	LIBDIR=%_libdir \
	WILL_DEAL_WITH_XDG_MYSELF=YES \
	CFLAGS='%optflags' \
	CXXFLAGS='%optflags' \
	CUSTOM_ENV=True \
	MANDIR=%_mandir \
	DESTDIR=%buildroot install

# remove unpackaged files
rm -f %buildroot%_libdir/libffado/static_info.txt
rm -f %buildroot%_datadir/metainfo/ffado-mixer.appdata.xml

%files
%doc AUTHORS ChangeLog LICENSE.* README
%_libdir/libffado.so.*

%files devel
%dir %_includedir/libffado
%_includedir/libffado/*.h
%_libdir/pkgconfig/libffado.pc
%_libdir/libffado.so

%files -n ffado
%_bindir/*
%_man1dir/*
%dir %_datadir/libffado
%_datadir/libffado/*
/lib/udev/rules.d/*ffado*.rules

%files -n %packagename
%python_sitelibdir_noarch/%modulename

%changelog
