%define soname 4
%define gtkver 2

%def_disable bootstrap

Name: libfm
Version: 1.3.1
Release: alt3

Summary: Core library of PCManFM file manager
License: GPL
Group: System/Libraries

Url: https://lxde.org
Source: %name-%version.tar
Patch0: 0001-SF-1087-Fix-all-allfiles-parse-conditions.patch
Patch1: 0002-SF-1082-Fix-SelectionCount-condition-parsing-if-was-.patch

%{?_disable_bootstrap:BuildPreReq: rpm-build-xdg}
BuildRequires: intltool %{?_disable_bootstrap:libmenu-cache-devel}
BuildRequires: libdbus-glib-devel libudisks2-devel
BuildRequires: glib2-devel libgtk+%gtkver-devel
BuildRequires: gtk-doc
BuildRequires: vala >= 0.13.0
BuildRequires: libexif-devel
BuildRequires: libxslt-devel

BuildRequires: gcc-c++ cmake rpm-macros-cmake

%description
LibFM is a core library of PCManFM file manager.

%package -n %name%soname
Summary: %summary
Group: System/Libraries
Requires: gvfs wm-common-freedesktop
Conflicts: libfm2

%description -n %name%soname
LibFM is a core library of PCManFM file manager.

It is developed as the core of next generation PCManFM and takes care
of all file-related operations such as copy & paste, drag & drop, file
associations or thumbnail support. By utilizing glib/gio and gvfs
libfm can access remote filesystems supported by gvfs.

%package devel
Summary: Development files for %name
Group: Development/Other
Conflicts: libfm2-devel

%description devel
This package contains files needed to build applications using LibFM.

%if_disabled bootstrap
%package -n lxde-lxshortcut
Summary: Application shortcuts editor
Group: Graphical desktop/Other

%description -n lxde-lxshortcut
LXShortcut is a small program used to edit application shortcuts
created with freedesktop.org Desktop Entry spec.
%endif

%prep
%setup
%patch0 -p1
%patch1 -p1
sed -ri '/AM_INIT_AUTOMAKE/s,-Werror,\0 -Wno-portability,' configure.ac

%build
%autoreconf
%configure \
    --disable-static \
    --disable-silent-rules \
%if_disabled bootstrap
    --with-gtk=%gtkver \
%else
    --with-extra-only \
    --with-gtk=no \
%endif
    --disable-gtk-doc \
    --enable-largefile \
    --enable-udisks \
    --sysconfdir=%_sysconfdir

%make_build

# FIXME: tilda versions don't work with RPM in general
sed -i 's,\~[a-z0-9]*,,g' libfm*.pc

%install
%makeinstall_std
%find_lang libfm

# Remove unnecessary files
rm -f %buildroot%_libdir/%name/modules/*.la
%if %gtkver==3
    rm -f %buildroot%_pkgconfigdir/libfm-gtk.pc
%endif
%if %gtkver==2
    rm -f %buildroot%_pkgconfigdir/libfm-gtk3.pc
%endif

%files -n %name%soname -f libfm.lang
%_libdir/*.so.*
%if_disabled bootstrap
%_xdgconfigdir/*
%dir %_libdir/%name
%dir %_libdir/%name/modules
%_libdir/%name/modules/*.so
%_xdgmimedir/packages/*
%_datadir/%name/
%_desktopdir/libfm-pref-apps.desktop
%_bindir/libfm-pref-apps
%_man1dir/libfm-pref-apps.1*
%endif

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
#%%doc %_datadir/gtk-doc/html/%name

%if_disabled bootstrap
%files -n lxde-lxshortcut
%_bindir/lxshortcut
%_desktopdir/lxshortcut.desktop
%_man1dir/lxshortcut.1*
%endif

%changelog
