%def_disable snapshot

%define _name folks
%define ver_major 0.12
%define api_ver 0.6

%def_disable libsocialweb
%def_disable tracker
%def_enable eds
%def_enable bluez
%def_enable zeitgeist
%def_disable check

Name: lib%_name
Version: %ver_major.1
Release: alt1

Summary: GObject contact aggregation library
Group: System/Libraries
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/Folks

%if_disabled snapshot
Source: http://download.gnome.org/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

%define glib_ver 2.44.0
%define tp_glib_ver 0.19.9
%define vala_ver 0.22.1
%define eds_ver 3.13.90
%define tracker_ver 0.15.2
%define gee_ver 0.8.4
%define zeitgeist_ver 0.9.15

BuildRequires(pre): meson rpm-build-vala rpm-build-gir
BuildRequires: vala-tools >= %vala_ver valadoc
BuildRequires: libgio-devel >= %glib_ver libdbus-glib-devel
BuildRequires: libtelepathy-glib-devel >= %tp_glib_ver libtelepathy-glib-vala libgee0.8-devel >= %gee_ver
BuildRequires: gobject-introspection-devel libgee0.8-gir-devel libtelepathy-glib-gir-devel libgee0.8-gir-devel
%{?_enable_eds:BuildRequires: evolution-data-server-devel >= %eds_ver evolution-data-server-gir-devel evolution-data-server-vala}
%{?_enable_zeitgeist:BuildRequires: libzeitgeist2.0-devel >= %zeitgeist_ver}
%{?_enable_tracker:BuildRequires: tracker-devel >= %tracker_ver libtracker-gir-devel}
%{?_enable_libsocialweb:BuildRequires: libsocialweb-devel libsocialweb-gir-devel libsocialweb-vala}
# for tools
BuildRequires: libreadline-devel libncurses-devel libxml2-devel
%{?_enable_check:BuildRequires: dbus-tools-gui}

%description
%name is a library that aggregates people from multiple sources (e.g.
Telepathy connection managers and eventually evolution data server,
Facebook, etc.) to create meta-contacts.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the %_name library
Group: System/Libraries
Requires: %name = %version-%release
Provides: typelib(Folks) = %ver_major

%description gir
GObject introspection data for the %_name library

%package gir-devel
Summary: GObject introspection devel data for the %_name library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the %_name library

%package vala
Summary: vala language bindings for %_name library
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description vala
This package provides vala language bindings for %_name library

%package tests
Summary: Tests for the Folks
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the Folks library.


%prep
%setup -n %_name-%version

%build
%meson \
	%{?_enable_zeitgeist:-Dzeitgeist=true} \
	%{?_disable_eds:-Deds_backend=false} \
	%{?_enable_tracker:-Dtracker_backend=true} \
	%{?_enable_libsocialweb:-Dlibsocialweb_backend=true} \
	%{?_disable_bluez:-Dbluez_backend=false} \
	%{?_enable_installed_tests:-Dinstalled_tests=true}

%meson_build

%install
%meson_install
%find_lang %_name

%check
%meson_test

%files -f %_name.lang
%_libdir/*.so.*
%_libdir/%_name/
%_datadir/glib-2.0/schemas/org.freedesktop.%_name.gschema.xml
%doc AUTHORS README*

%files devel
%_bindir/%_name-import
%_bindir/%_name-inspect
%_includedir/%_name
%_libdir/*.so
%_libdir/pkgconfig/%{_name}*.pc

%files gir
%_typelibdir/FolksDummy-%api_ver.typelib
%_typelibdir/Folks-%api_ver.typelib
%_typelibdir/FolksEds-%api_ver.typelib
%_typelibdir/FolksTelepathy-%api_ver.typelib
%{?_enable_tracker:%_typelibdir/FolksTracker-%api_ver.typelib}

%files gir-devel
%_girdir/FolksDummy-%api_ver.gir
%_girdir/Folks-%api_ver.gir
%_girdir/FolksEds-%api_ver.gir
%_girdir/FolksTelepathy-%api_ver.gir
%{?_enable_tracker:%_girdir/FolksTracker-%api_ver.gir}

%files vala
%_vapidir/%_name.deps
%_vapidir/%_name-dummy.deps
%_vapidir/%_name-dummy.vapi
%_vapidir/%_name-eds.deps
%_vapidir/%_name-eds.vapi
%{?_enable_libsocialweb:%_vapidir/%_name-libsocialweb.deps}
%{?_enable_libsocialweb:%_vapidir/%name-libsocialweb.vapi}
%_vapidir/%_name-telepathy.deps
%_vapidir/%_name-telepathy.vapi
%{?_enable_tracker:%_vapidir/%_name-tracker.deps}
%{?_enable_tracker:%_vapidir/%_name-tracker.vapi}
%_vapidir/%_name.vapi

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name/
%_datadir/installed-tests/%_name/
%endif


%changelog
