%define _unpackaged_files_terminate_build 1

Name: libfprint2
Version: 1.90.7
Release: alt1

Summary: Tool kit for fingerprint scanner
License: LGPLv2+
Group: System/Libraries

Url: http://www.freedesktop.org/wiki/Software/fprint/libfprint
# git://anongit.freedesktop.org/libfprint/libfprint
# https://gitlab.freedesktop.org/libfprint/libfprint
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): meson
BuildRequires: libusb-devel libnss-devel glib2-devel libImageMagick-devel libXv-devel libpixman-devel
BuildRequires: gcc-c++ doxygen 
BuildRequires: libgio-devel libgusb-devel libudev-devel gtk-doc libcairo-devel cmake
BuildRequires: /proc python3-module-pygobject3
BuildRequires: gobject-introspection-devel libgusb-gir-devel

%description
The fprint project aims to support for consumer fingerprint reader
devices.

%package gir
Summary: GObject introspection data for the %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for %name

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for %name

%prep
%setup
%patch -p1

%build
%meson -Ddrivers=all \
       -Dintrospection=true \
       -Dudev_rules=true \
       -Dudev_rules_dir=%_sysconfdir/udev/rules.d/ \
       -Dgtk-examples=false \
       -Ddoc=true
export LD_LIBRARY_PATH="libfprint"
%meson_build

%install
%meson_install

%check
%meson_test

%files
%doc COPYING INSTALL NEWS TODO THANKS AUTHORS README
%_libdir/*.so.*
%_sysconfdir/udev/rules.d/60-libfprint-2-autosuspend.rules

%files gir
%_libdir/girepository-1.0/*.typelib

%files devel
%doc HACKING.md
%doc %_datadir/gtk-doc/html/libfprint-2
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/libfprint-2.pc

%files gir-devel
%_datadir/gir-1.0/*.gir

%changelog
