# some online tests
%def_disable check

Name: libgit2
Version: 0.28.3
Release: alt1

Summary: linkable library for Git
License: GPLv2 with linking exception

Group: System/Libraries
Url: https://github.com/%name

Source: %url/%name/archive/v%version/%name-%version.tar.gz

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake python-modules zlib-devel libssl-devel libssh2-devel

%description
libgit2 is a portable, pure C implementation of the Git core methods
provided as a re-entrant linkable library with a solid API, allowing you
to write native speed custom Git applications in any language which
supports C bindings.

%package devel
Group: Development/C
Summary: linkable library for Git - development files
Requires: %name = %version-%release

%description devel
libgit2 is a portable, pure C implementation of the Git core methods
provided as a re-entrant linkable library with a solid API, allowing you
to write native speed custom Git applications in any language which
supports C bindings.
This package contains development files.

%prep
%setup
rm -rf deps/{regex,zlib}
sed -i 's/LIB_INSTALL_DIR lib/LIB_INSTALL_DIR lib${LIB_SUFFIX}/' CMakeLists.txt
sed -i 's/@CMAKE_INSTALL_PREFIX@\///' %name.pc.in

%build
%cmake -DTHREADSAFE:BOOL=ON \
       -DUSE_SHA1DC:BOOL=ON
%cmake_build

%install
%cmakeinstall_std

%check
%make -C BUILD test

%files
%_libdir/%name.so.*
%doc README.md AUTHORS COPYING

%files devel
%_includedir/git2
# exclude headers for windows
%exclude %_includedir/git2/inttypes.h
%exclude %_includedir/git2/stdint.h
%_includedir/git2.h
%_libdir/%name.so
%_pkgconfigdir/%name.pc

%changelog
