# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/valgrind gcc-c++
# END SourceDeps(oneline)
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:      libgta
Version:   1.0.9
Release:   alt1_1
Summary:   Library that implements the Generic Tagged Arrays file format
Group:     System/Libraries
License:   LGPLv2+
URL:       https://marlam.de/gta/
Source0:   https://marlam.de/gta/releases/%{name}-%{version}.tar.xz
BuildRequires: gcc
BuildRequires: doxygen
BuildRequires: bzlib-devel
BuildRequires: zlib-devel
BuildRequires: liblzma-devel
Source44: import.info

%description
Libgta is a portable library that implements the GTA (Generic Tagged Arrays)
file format. It provides interfaces for C and C++.


%package devel
Summary:  Development Libraries for %{name}
Group:    Development/Other
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%package doc
Summary:  API documentation for %{name}
Group:    Documentation
Requires: %{name} = %{version}-%{release}
BuildArch: noarch

%description doc
The %{name}-doc package contains HTML API documentation and
examples for %{name}.


%prep
%setup -q

# Preserve date for headers
# Sent to gta-list@nongnu.org
sed -i 's/-m 644/-pm 644/' configure


%build
%configure --disable-static
%make_build V=1

%install
make install DESTDIR=%{buildroot}

# Remove documentation; will install it with doc macro
rm -rf %{buildroot}%{_docdir}


%check
make check V=1


%files 
%doc COPYING AUTHORS README
%{_libdir}/%{name}.so.*

%files devel
%{_datadir}/%{name}/cmake/FindGTA.cmake
%{_libdir}/pkgconfig/gta.pc
%{_includedir}/gta
%{_libdir}/%{name}.so

%files doc
%doc doc/example*
%doc doc/reference


%changelog
