%define oldname libgtop2
%define ver_major 2.40
%define api_ver 2.0

%def_disable static
%def_with examples
%def_enable introspection

Name: libgtop
Version: %ver_major.0
Release: alt1

Summary: LibGTop library
License: GPLv2+
Group: System/Libraries
Url: ftp://ftp.gnome.org

Obsoletes: %oldname < 2.14.2
Provides: %oldname = %version-%release

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Patch2: %name-2.0.0-texinfo.patch
Patch4: %name-2.9.90-alt-examples_makefile.patch

# from configure.ac
%define glib_ver 2.26.0

BuildPreReq: rpm-build-gnome
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: gtk-doc >= 1.4
BuildRequires: makeinfo
BuildRequires: libICE-devel libX11-devel perl-XML-Parser
%{?_enable_static:BuildPreReq: glibc-devel-static}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.6.7}

%description
LibGTop is a library that fetches information about the running
system such as CPU and memory useage, active processes and more.

On Linux systems, this information is taken directly from the /proc
filesystem while on other systems a server is used to read that
information from other /dev/kmem, among others.

%package examples
Group: Development/GNOME and GTK+
Summary: The LibGTop samples
Obsoletes: %oldname-examples < 2.14.2
Provides: %oldname-examples = %version-%release
Requires: %name = %version-%release

%description examples
This package contains some example of using %name library

%package devel
Summary: Development files for %name
Group: Development/GNOME and GTK+
Obsoletes: %oldname-devel < 2.14.2
Provides: %oldname-devel = %version-%release
Requires: %name = %version-%release

%description devel
LibGTop is a library that fetches information about the running
system such as CPU and memory useage, active processes and more.

Install this package if you wish to develop applications that access
information on system statistics such as CPU and memory usage.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: %name-devel < %version-%release
BuildArch: noarch

%description devel-doc
LibGTop is a library that fetches information about the running
system such as CPU and memory useage, active processes and more.

This package contains development documentation for the library.

%package devel-static
Summary: Static libraries for %name
Group: Development/GNOME and GTK+
Obsoletes: %oldname-devel-static < 2.14.2
Provides: %oldname-devel-static = %version-%release
Requires: %name-devel = %version-%release

%description devel-static
This package contains static libraries for development with %name.

%package gir
Summary: GObject introspection data for the LibGTop library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the LibGTop library

%package gir-devel
Summary: GObject introspection devel data for the LibGTop library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the LibGTop library


%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup
%patch2 -p1
%patch4 -p1

rm -rf doc/*.info

%build
%autoreconf
%configure \
	%{subst_enable static} \
	--enable-gtk-doc \
	%{subst_with examples}
%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_bindir/%{name}_daemon2
%attr(4711,root,root) %_bindir/%{name}_server2
%_libdir/*.so.*
%doc AUTHORS NEWS README

%if_with examples
%files examples
%dir %_libdir/%name
%_libdir/%name/*
%endif

%files devel
%_includedir/%name-%api_ver/
%_libdir/*.so
%_pkgconfigdir/*
%_infodir/*.info*

%files devel-doc
%_gtk_docdir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files gir
%_typelibdir/GTop-%api_ver.typelib

%files gir-devel
%_girdir/GTop-%api_ver.gir
%endif

%changelog
