%define _name gupnp
%define ver_major 1.2
%define api_ver 1.2

%def_disable static
%def_disable gtk_doc
%def_enable introspection
%def_enable vala
%def_enable check

Name: lib%_name%ver_major
Version: %ver_major.1
Release: alt1

Summary: A framework for creating UPnP devices and control points
Group: System/Libraries
License: LGPLv2+
Url: http://www.gupnp.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildRequires(pre): meson rpm-build-gir
BuildRequires: libgssdp%ver_major-devel >= %ver_major libgio-devel >= 2.40.0
BuildRequires: libxml2-devel libsoup-devel >= 2.48 libuuid-devel gtk-doc
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libsoup-gir-devel libgssdp%ver_major-gir-devel}

%description
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%package devel
Summary: Development files and libraries for gUPnP
Group: Development/C
Requires: %name = %version-%release

%description devel
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

This package provides files for development with gUPnP.

%package devel-doc
Summary: Development documentaion for gUPnP
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

This package provides development documentations for gUPnP.

%package gir
Summary: GObject introspection data for the gUPnP library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the gUPnP library

%package gir-devel
Summary: GObject introspection devel data for the gUPnP library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the gUPnP library


%prep
%setup -n %_name-%version

%build
%meson \
%{?_enable_gtk_doc:-Dgtk_doc=true} \
%{?_disable_introspection:-Dintrospection=false} \
%{?_disable_vala:-Dvapi=false}

%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_bindir/gupnp-binding-tool-%api_ver
%_libdir/lib%_name-%api_ver.so.*
%doc AUTHORS README ChangeLog

%files devel
%_pkgconfigdir/%_name-%api_ver.pc
%_libdir/lib%_name-%api_ver.so
%_includedir/%_name-%api_ver/
%_vapidir/%_name-%api_ver.deps
%_vapidir/%_name-%api_ver.vapi

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name
%endif

%if_enabled introspection
%files gir
%_typelibdir/GUPnP-%api_ver.typelib

%files gir-devel
%_girdir/GUPnP-%api_ver.gir
%endif


%changelog
