%define _libexecdir %_prefix/libexec

%define _name json-glib
%define ver_major 1.4
%define api_ver 1.0
%def_disable docs
%def_enable introspection
%def_enable check

Name: lib%_name
Version: %ver_major.4
Release: alt1

Summary: GLib-based JSON manipulation library
Group: System/Libraries
License: LGPLv2.1
Url: https://wiki.gnome.org/Projects/JsonGlib

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

%define glib_ver 2.46.0
%define gi_ver 0.10.5

BuildRequires(pre): meson
BuildRequires: glib2-devel >= %glib_ver
%{?_enable_static:BuildPreReq: glibc-devel-static}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
%{?_enable_docs:BuildRequires: gtk-doc xsltproc docbook-dtds docbook-style-xsl}

%description
JSON-GLib implements a full JSON parser using GLib and GObject. Use
JSON-GLib it is possible to parse and generate valid JSON data
structures, using a DOM-like API. JSON-GLib also offers GObject
integration, providing the ability to serialize and deserialize GObject
instances to and from JSON data types.

%package devel
Summary: Development files for %_name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the JSON-GLib library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the JSON-GLib library

%package gir-devel
Summary: GObject introspection devel data for the JSON-GLib library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the JSON-GLib library

%package tests
Summary: Tests for the %_name package
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %_name library.


%prep
%setup -n %_name-%version

%build
%meson %{?_disable introspection:-Ddisable-introspection=true} \
	%{?_enable_docs:-Denable-docs=true}

%meson_build

%install
%meson_install

%find_lang --output=%_name.lang %_name-%api_ver

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %_name.lang
%_bindir/%_name-format
%_bindir/%_name-validate
%_libdir/*.so.*
%if_enabled man
%{?_enable_docs:%_man1dir/%_name-format.1.*}
%{?_enable_docs:%_man1dir/%_name-validate.1.*}
%endif
%doc NEWS README.md

%files devel
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*
%if_enabled docs
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files gir
%_typelibdir/Json-%api_ver.typelib

%files gir-devel
%_girdir/Json-%api_ver.gir
%endif

%files tests
%_libexecdir/installed-tests/%_name-%api_ver/
%_datadir/installed-tests/%_name-%api_ver/

%changelog
