#
# spec file for package liblnk
#
# Copyright (c) 2013 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

Name: liblnk
Version: 20140323
Release: alt1

Summary: Library and tools to access the Windows Shortcut File (LNK) format
License: LGPLv3+ and GFDL-1.3+
Group: File tools

Url: http://code.google.com/p/liblnk/
#DL-URL: https://googledrive.com/host/0B3fBvzttpiiSQmluVC1YeDVvZWM/liblnk-alpha-20131015.tar.gz
Source0: %name-alpha-%version.tar.gz
Source1: Windows_Shortcut_File_(LNK)_format.pdf
Source2: liblnk.watch
Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: pkg-config
BuildRequires: python-dev
BuildRequires: pkgconfig(libbfio) >= 20130721
BuildRequires: pkgconfig(libcdata) >= 20130904
BuildRequires: pkgconfig(libcfile) >= 20130609
BuildRequires: pkgconfig(libclocale) >= 20130609
BuildRequires: pkgconfig(libcnotify) >= 20130609
BuildRequires: pkgconfig(libcpath) >= 20130609
BuildRequires: pkgconfig(libcsplit) >= 20130609
BuildRequires: pkgconfig(libfdatetime) >= 20130317
BuildRequires: pkgconfig(libfguid) >= 20130904
BuildRequires: pkgconfig(libuna) >= 20120425
# the below failed to compile with factory version as of Nov 1, 2013
#BuildRequires:  pkgconfig(libcerror) >= 20120425
# the below are not released as standalone packages by upstream
#BuildRequires:  pkgconfig(libfwsi) >= 20120426
#BuildRequires:  pkgconfig(libcsystem) >= 20120425
#BuildRequires:  pkgconfig(libcstring) >= 20120425

%description
liblnk is a library to access Windows Shortcut File (LNK) files.

%package tools
Summary: Tools to access the Windows Shortcut File (LNK) format
License: LGPLv3+
Group: File tools

%description tools
liblnk is a library to access Windows Shortcut File (LNK) files.

%package devel
Summary: Development files for liblnk, a library to access Windows Shortcut Links
License: LGPLv3+ and GFDL-1.3+
Group: Development/C
Requires: %name = %version

%description devel
liblnk is a library to access Windows Shortcut File (LNK) files.

This subpackage contains libraries and header files for developing
applications that want to make use of %name.

%package -n python-module-%name
Summary: Python bindings for liblnk, a Windows Shortcut Link parser
License: LGPLv3+
Group: Development/Python
Requires: python-base

%description -n python-module-%name
Python binding for liblnk, which can read Windows Shortcut Link files.

%prep
%setup
cp -a "%SOURCE1" .

%build
%configure \
	--disable-static \
	--enable-wide-character-type \
	--enable-python
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog
%_libdir/liblnk.so.*

%files tools
%_bindir/lnk*
%_man1dir/lnkinfo.1*

%files devel
%doc Windows_Shortcut_File_*.pdf
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man3dir/*

%files -n python-module-%name
%doc AUTHORS README
%python_sitelibdir/pylnk.so

%changelog
