%def_with doc
Name: libmodbus
Version: 3.1.6
Release: alt2

Summary: A Modbus library in C, which supports RTU communication over a serial line or a TCP link

License: LGPL V3+
Url: http://www.libmodbus.org
Group: System/Libraries

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://libmodbus.org/releases/libmodbus-%version.tar.gz
Source: %name-%version.tar

# Automatically added by buildreq on Tue Mar 30 2010
BuildRequires: gcc-c++
%if_with doc
BuildRequires: xmlto asciidoc-a2x
%endif

%description
A Modbus library for Linux (and OSX) wrote in C and which supports
RTU communication over a serial line or a TCP link. Clean and fast!
Supports controling an RTU and being an RTU.

%package devel
Summary: Headers and development files of %name library
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains the headers and various development files needed
for compiling or development of applications that wants C++ interface
of %name library.

%prep
%setup

%build
%autoreconf
%configure \
%if_without doc
    --without-documentation \
%endif
    %nil
%make_build

%install
#mkdir -p -m755 %buildroot/
%makeinstall_std
rm -rfv %buildroot%_docdir/%name/
#mkdir -p -m755 %buildroot%_datadir/libmodbus/
#ls -lRh %buildroot/

%files
%doc AUTHORS MIGRATION NEWS COPYING* README.md
%_libdir/libmodbus.so.*

%files devel
%_libdir/libmodbus.so
%_pkgconfigdir/libmodbus.pc
%dir %_includedir/modbus/
%_includedir/modbus/modbus.h
%_includedir/modbus/modbus-rtu.h
%_includedir/modbus/modbus-tcp.h
%_includedir/modbus/modbus-version.h
%if_with doc
%_man3dir/*
%_man7dir/*
%endif

%changelog
