# examples depend on this
%def_with check
%def_enable check

Name: libnftnl
Version: 1.1.8
Release: alt1

Summary: Netfilter nf_tables infrastructure library
License: GPL-2.0-only
Group: System/Libraries

Url: http://netfilter.org/projects/libnftnl/
Source: %name-%version.tar
BuildRequires: libmnl-devel libmxml-devel libjansson-devel

%description
libnftnl is a userspace library providing a low-level netlink
programming interface (API) to the in-kernel nf_tables subsystem.
The library libnftnl has been previously known as libnftables.
This library is currently used by nftables.

%package devel
Summary: Development files for %name
Group: System/Libraries
Requires: pkgconfig, %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-static
Summary: Development files for %name
Group: System/Libraries
Requires: pkgconfig, %name = %version-%release

%description devel-static
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package examples
Summary: Examples for %name
Group: System/Libraries

%description examples
The %name-examples package contains examples files for %name.

%prep
%setup

%build
%autoreconf
%configure --with-xml-parsing --with-json-parsing --enable-static
%make_build

# FIXME: --without check will cause packaging breakage
%check
%make check
mkdir -p %buildroot%_sbindir
cp -a examples/.libs/* %buildroot%_sbindir/

%install
%makeinstall_std

%files
%doc COPYING
%_libdir/%name.so.*

%files devel
%_libdir/*.so
%_includedir/%name
%_libdir/pkgconfig/*.pc

%files devel-static
%_libdir/*.a

%if_with check
%if_enabled check
%files examples
%doc examples/*.c
%_sbindir/*
%endif
%endif

%changelog
