%define _unpackaged_files_terminate_build 1
# Suppress warning emerging from mentioning this macro in changelog
%define _sysconfigdir /etc

# Enable cmake RPATH for unit tests
%global _cmake_skip_rpath %nil

Name: libnss-role
Version: 0.5.6
Release: alt1

Summary: NSS API library and admin tools for roles and privilegies

License: LGPLv2.1
URL: https://github.com/altlinux/libnss-role
Group: System/Libraries

Packager: Vitaly Lipatov <lav@altlinux.ru>

# https://github.com/altlinux/libnss-role.git
Source: %name-%version.tar

BuildRequires: glibc-devel
BuildRequires: cmake
BuildRequires: ctest
BuildRequires: libcmocka
BuildRequires: libcmocka-devel
BuildRequires: libpam0
BuildRequires: libpam0-devel
BuildRequires: nss_wrapper

Requires: libpam0 chrooted >= 0.3.5-alt1 chrooted-resolv control

%description
NSS API library and admin tools for roles and privilegies.

%package devel
Summary: Header for developing applications managing Roles
Group: Development/Other
Requires: %name = %version-%release

%description devel
Headers for developing applications managing Roles throw
NSS API library for roles and privilegies.

%prep
%setup

%build
%cmake \
	-DNSS_LIBDIR=/%_lib \
	-DROLE_LIBDIR=%_libdir \
	-DMANDIR=%_man8dir \
	-DCMAKE_INSTALL_PREFIX:PATH=%_prefix
%cmake_build
%cmake_build -t all_tests

%check
%cmake_build -- all_tests
%_cmake__builddir/checkver %version

%install
%cmakeinstall_std
mkdir -p %buildroot%_sysconfdir/role.d

# control support
install -pD -m755 %name.control %buildroot%_controldir/%name

%post
control libnss-role enabled
update_chrooted all

%preun
control libnss-role disabled
update_chrooted all

%files
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/role
%dir %_sysconfdir/role.d
%_sysconfdir/pam.d/role*
/%_lib/libnss_*.so.*
%_sbindir/roleadd
%_sbindir/roledel
%_bindir/rolelst
%_libdir/*.so.*
%_man8dir/*
%config %_controldir/%name

%files devel
%_libdir/*.so
%_includedir/role/

%changelog
