Name: libpng12
Version: 1.2.59
Release: alt1

Summary: PNG runtime legacy library
License: zlib
Group: System/Legacy libraries
Url: http://www.libpng.org/pub/png/

# http://download.sourceforge.net/libpng/libpng-%version.tar.xz
Source: libpng-%version.tar
Patch: libpng-%version-%release.patch

%def_disable static

Provides: libpng = %version
Conflicts: libpng3 < 1.2.13-alt1

# Automatically added by buildreq on Tue Feb 08 2011
BuildRequires: zlib-devel

%package -n libpng3
Summary: PNG runtime legacy library
Group: System/Legacy libraries
Requires: %name = %version-%release

%package devel
Summary: PNG development library
Group: Development/C
Requires: %name = %version-%release, zlib-devel
Provides: libpng3-devel = %version
Obsoletes: libpng3-devel < %version
Conflicts: libpng2-devel libpng15-devel libpng-devel

%package devel-static
Summary: PNG static library
Group: Development/C
Requires: %name-devel = %version-%release, zlib-devel-static
Provides: libpng3-devel-static = %version
Obsoletes: libpng3-devel-static < %version
Conflicts: libpng2-devel-static

%description
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

This package contains the runtime legacy library files needed to run
legacy software using %name.

%description -n libpng3
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

This package is superseded by %name, and is provided only for
transitional purposes.

%description devel
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

This package contains the header and development files needed to build
programs and packages using %name.

%description devel-static
This package contains static legacy library necessary for developing
statically linked legacy programs using the PNG (Portable Network
Graphics) library.

%prep
%setup -n libpng-%version
%patch -p1

%build
%autoreconf
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std
rm %buildroot%_libdir/lib*.la

%define docdir %_docdir/libpng-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -p -m644 CHANGES KNOWNBUG LICENSE README TODO example.c libpng*.txt \
	%buildroot%docdir/
xz -9 %buildroot%docdir/*.txt %buildroot%docdir/CHANGES

%filter_from_provides /^pkgconfig(libpng)/d

%check
%make_build -k check

%files
%_libdir/%name.so.*
%exclude %_man5dir/*

%files -n libpng3
%_libdir/libpng.so.*

%files devel
%_bindir/*-config
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_man3dir/*
%docdir

%if_enabled static
%files devel-static
%_libdir/%name.a
%endif

%changelog
