%define bname librsvg
%define ver_major 2.46
%define api_ver 2.0
%define gtk_api_ver 2.0
%define gtk3_api_ver 3.0

%def_disable static
%def_disable gtk_doc
%def_enable pixbuf_loader
%def_enable introspection
%def_enable vala
%def_disable check

Name: %bname
Version: %ver_major.4
Release: alt1
Epoch: 1

Summary: SVG rendering library
License: LGPLv2.1+
Group: System/Libraries
Url: https://wiki.gnome.org/action/show/Projects/LibRsvg

Source: ftp://ftp.gnome.org/pub/gnome/sources/%bname/%ver_major/%bname-%version.tar.xz

# From configure.ac
%define glib_ver 2.52.0
%define gtk3_ver 3.10.0
%define libxml2_ver 2.7.0
%define cairo_ver 1.15.12
%define croco_ver 0.6.7
%define vala_ver 0.18
%define freetype_ver 2.9
%define rust_ver 1.34

Requires(pre): libcroco >= %croco_ver

# From configure.ac
BuildPreReq: libgtk+3-devel >= %gtk3_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: libcairo-devel >= %cairo_ver
BuildPreReq: libcroco-devel >= %croco_ver
BuildPreReq: libfreetype-devel >= %freetype_ver
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel}
BuildRequires: libX11-devel libXt-devel
BuildRequires: gcc-c++ gtk-doc intltool sgml-common zlib-devel
%{?_enable_vala:BuildRequires: vala-tools >= %vala_ver rpm-build-vala}
# sinc 2.41.0
BuildRequires: /proc rust >= %rust_ver rust-cargo

%description
A high performance SVG rendering library associated with the Gnome Project.

%package devel
Summary: Libraries and include files for developing with librsvg
Group: Development/C
Requires: %bname = %EVR

%description devel
This package provides the necessary development libraries and include
files to allow you to develop with librsvg.

%package devel-doc
Summary: Development documentation for %bname
Group: Development/Documentation
BuildArch: noarch
Conflicts: %bname < %EVR

%description devel-doc
%bname is a SVG library based on libart.
This package contains development documentation for %bname

%package devel-static
Summary: Static libraries for developing with librsvg
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
This package provides the necessary static libraries files to allow you
to build static software with librsvg.

%package utils
Summary: Utilities to manipulate SVG files
Group: Graphics
Requires: %bname = %EVR

%description utils
This package contains small utilities to manipulate SVG files found in
%bname package.

%package -n libgtk-engine-svg
Summary: A GTK+ engine for graphical themes that use SVG images.
Group: Graphical desktop/GNOME
Requires: %bname = %EVR

%description -n libgtk-engine-svg
This package contains a GTK+2 engine that renders graphical themes with SVG
images in them.

%package gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %name library

%package gir-devel
Summary: GObject introspection devel data for the %name library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the %name library


%define _gtk_docdir %_datadir/gtk-doc/html/

%prep
%setup -n %bname-%version

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%autoreconf
%configure \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{?_enable_pixbuf_loader:--enable-pixbuf-loader} \
	%{?_enable_introspection:--enable-introspection=yes} \
	%{?_enable_vala:--enable-vala=yes}

%make_build

%install
%makeinstall_std

%check
%make check

%files
%_libdir/*.so.*
%{?_enable_pixbuf_loader:%_libdir/gdk-pixbuf-%gtk_api_ver/*/loaders/*.so}
%_datadir/thumbnailers/librsvg.thumbnailer
%doc AUTHORS NEWS README*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/%bname-%gtk_api_ver.pc
%{?_enable_vala:%_vapidir/%name-%api_ver.vapi}

%files devel-doc
%_gtk_docdir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%{?_enable_pixbuf_loader:%_libdir/gdk-pixbuf-%gtk_api_ver/*/loaders/*.a}
%endif

%files utils
%_bindir/*
%_man1dir/*

%if_enabled introspection
%files gir
%_typelibdir/Rsvg-%api_ver.typelib

%files gir-devel
%_girdir/Rsvg-%api_ver.gir
%endif

%{?_enable_pixbuf_loader:%exclude %_libdir/gdk-pixbuf-%gtk_api_ver/*/loaders/*.la}

%changelog
