
Name: libseccomp
Version: 2.4.2
Release: alt2
Summary: High level interface to the Linux Kernel's seccomp filter
License: LGPLv2.1+
Group: System/Libraries
Url: https://github.com/seccomp/libseccomp

#https://github.com/seccomp/libseccomp.git
Source: %name-%version.tar
Patch1: %name-%version.patch

%description
The libseccomp library provides and easy to use, platform independent,
interface to the Linux Kernel's syscall filtering mechanism: seccomp.
The libseccomp API is designed to abstract away the underlying BPF based
syscall filter language and present a more conventional function-call
based filtering interface that should be familiar to, and easily adopted
by application developers.

%package devel
Summary: Development files of %name
Group: Development/C
Requires: %name = %EVR

%description devel
The libseccomp library provides and easy to use, platform independent,
interface to the Linux Kernel's syscall filtering mechanism: seccomp.
The libseccomp API is designed to abstract away the underlying BPF based
syscall filter language and present a more conventional function-call
based filtering interface that should be familiar to, and easily adopted
by application developers.

This package contains development files of %name.

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure --disable-static --enable-silent-rules
%make_build

%install
%makeinstall_std

# Relocate shared library from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
        t=$(readlink -v "$f")
        ln -rsnf %buildroot/%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%files
%doc CHANGELOG CREDITS README.md
%_bindir/*
/%_lib/lib*.so.*
%_man1dir/*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%_man3dir/*

%changelog
