%define _unpackaged_files_terminate_build 1

%def_disable check

Name: libsepol
Epoch: 1
Version: 3.1
Release: alt1
Summary: SELinux binary policy manipulation library
License: LGPLv2+
Group: System/Libraries
Url: https://github.com/SELinuxProject/selinux

Source: %name-%version.tar

Conflicts: libsetools < 3.3.8-alt6

%{!?_disable_check:BuildRequires: CUnit-devel}
BuildRequires: flex

%description
libsepol provides an API for the manipulation of SELinux binary policies.
It is used by checkpolicy (the policy compiler) and similar tools, as well
as by programs like load_policy that need to perform specific transformations
on binary policies such as customizing policy boolean settings.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
libsepol provides an API for the manipulation of SELinux binary policies.
It is used by checkpolicy (the policy compiler) and similar tools, as well
as by programs like load_policy that need to perform specific transformations
on binary policies such as customizing policy boolean settings.

This package contains development library and header files for %name.

%package devel-static
Summary: Static development files for %name
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
libsepol provides an API for the manipulation of SELinux binary policies.
It is used by checkpolicy (the policy compiler) and similar tools, as well
as by programs like load_policy that need to perform specific transformations
on binary policies such as customizing policy boolean settings.

This package contains static library.

%package utils
Summary: Utils for checking and mainplating policy binaries Security-enhanced Linux
Group: System/Configuration/Other
Provides: chkcon = %EVR
Requires: %name = %EVR

%description utils
libsepol provides an API for the manipulation of SELinux binary policies.
It is used by checkpolicy (the policy compiler) and similar tools, as well
as by programs like load_policy that need to perform specific transformations
on binary policies such as customizing policy boolean settings.

%prep
%setup

%build
%make_build CFLAGS="%optflags" LIBDIR=%_libdir SHLIBDIR=/%_lib all

%install
%makeinstall_std LIBDIR=%_libdir SHLIBDIR=/%_lib

# TODO: currently only man8dir is translated. If other man pages are translated, %%find_lang use should be improved
%find_lang --with-man --all-name %name

%check
%make_build test

%files
/%_lib/*

%files devel
%_libdir/*.so
%_includedir/sepol
%_pkgconfigdir/*
%_man3dir/*

%files devel-static
%_libdir/*.a

%files utils -f %name.lang
%_bindir/*
%_man8dir/*
%exclude %_man8dir/genpol*

%changelog
