%def_disable snapshot

%define _name libsigc++
%define ver_major 3.0
%define api_ver 3.0
%def_enable check

Name: %{_name}3
Version: %ver_major.0
Release: alt1

Summary: The Typesafe Callback Framework for C++
License: LGPLv2+
Group: System/Libraries
Url: https://libsigcplusplus.github.io/libsigcplusplus/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
#VCS: https://github.com/libsigcplusplus/libsigcplusplus.git
Source: %_name-%version.tar
%endif

BuildRequires: gcc-c++ mm-common >= 0.9.12
BuildRequires: docbook-style-xsl doxygen graphviz xsltproc

%description
libsigc++ implements a typesafe callback system for standard C++.
It allows you to define signals and to connect those signals to any
callback function, either global or a member function, regardless of
whether it is static or virtual.

%package devel
Summary: Development files for libsigc++ library
Group: Development/C++
Requires: %name = %version-%release

%description devel
This package contains development files for the software development
using libsigc++ library.

%package doc
Summary: Documentation for libsigc++ library
Group: Books/Other
BuildArch: noarch

%description doc
This package provides API documentation of libsigc++ library.

%prep
%setup -n %_name-%version

%build
mm-common-prepare -f
%autoreconf
%configure --disable-static
%make_build DOCBOOK_STYLESHEET=/usr/share/xml/docbook/xsl-stylesheets/html/chunk.xsl

%install
%makeinstall_std
%define docdir %_docdir/libsigc++-%api_ver
install -pm644 AUTHORS NEWS README* %buildroot%docdir/

%check
%make_build -k check

%files
%_libdir/*.so.*
%dir %docdir
%docdir/[ANR]*

%files devel
%_libdir/*.so
%_libdir/sigc*
%_includedir/*
%_pkgconfigdir/*

%files doc
%docdir
%exclude %docdir/[ANR]*
%doc %_datadir/devhelp/books/*

%changelog
