Name: libsigsegv
Version: 2.12.0.11.f2e3
Release: alt1

Summary: Library for handling page faults in user mode
License: GPL-2.0-or-later
Group: System/Libraries

Url: https://www.gnu.org/software/libsigsegv/
# https://git.sv.gnu.org/git/libsigsegv
# git://git.altlinux.org/gears/l/libsigsegv
%define srcname %name-%version-%release
Source: %srcname.tar

BuildRequires: gnulib >= 0.1.2433.3043e

%define libname %{name}2

%description
This is a library for handling page faults in user mode.  A page fault
occurs when a program tries to access to a region of memory that is
currently not available.  Catching and handling a page fault is a useful
technique for implementing:
  - pageable virtual memory
  - memory-mapped access to persistent databases
  - generational garbage collectors
  - stack overflow handlers
  - distributed shared memory

%package -n %libname
Summary: Library for handling page faults in user mode
Group: System/Libraries
Provides: %name = %EVR
Obsoletes: %name < %version

%description -n %libname
This is a library for handling page faults in user mode.  A page fault
occurs when a program tries to access to a region of memory that is
currently not available.  Catching and handling a page fault is a useful
technique for implementing:
  - pageable virtual memory
  - memory-mapped access to persistent databases
  - generational garbage collectors
  - stack overflow handlers
  - distributed shared memory

%package devel
Summary: GNU libsigsegv development library and header files
Group: Development/C
Requires: %libname = %EVR
Obsoletes: libsigsegv0-devel < %version

%description devel
The development library and header files for building applications
with GNU libsigsegv.

%prep
%setup -n %srcname
# Build scripts expect to find the version in this file.
echo -n %version > .tarball-version

%build
GNULIB_TOOL=gnulib-tool sh -x ./autogen.sh
%configure --disable-silent-rules --enable-shared --disable-static
%make_build

%install
%makeinstall_std

%check
%make_build -k check

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%files -n %libname
%_libdir/*.so.*
%doc AUTHORS README NEWS

%files devel
%_libdir/*.so
%_includedir/*

%changelog
