%def_disable snapshot

%define api_ver 2.4
%define ver_major 2.66
%def_disable static
%def_enable gtk_doc
%def_with gnome
%def_enable introspection
%def_enable vala
%def_with gssapi
%def_disable debug
# fails server-test in hasher
%def_disable check

Name: libsoup
Version: %ver_major.2
Release: alt1

Summary: HTTP client/server library for GNOME
Group: System/Libraries
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/libsoup

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif

Source1: %name-compat.map
Source2: %name-compat.lds
Source3: %name-gnome-compat.map
Source4: %name-gnome-compat.lds
Patch1: %name-2.66.1-alt-compat-map.patch

Requires: glib-networking >= 2.59.90

Provides: soup = %version libsoup%api_ver = %version
Obsoletes: soup < %version libsoup%api_ver < %version

%define glib_ver 2.42.0
%define gi_ver 1.33.3
%define psl_ver 0.20.0

BuildRequires(pre): meson rpm-build-gir
BuildRequires: python3-base
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libxml2-devel libsqlite3-devel zlib-devel

BuildRequires: docbook-dtds docbook-style-xsl
BuildRequires: gtk-doc xml-common xsltproc
BuildRequires: glib-networking libpsl-devel >= %psl_ver
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
%{?_enable_vala:BuildRequires: vala-tools}
%{?_with_gssapi:BuildRequires: libkrb5-devel}
# for check
BuildRequires: /proc curl

%description
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

%package gnome
Summary: HTTP client/server library for GNOME (GNOME part)
Group: System/Libraries
Requires: %name = %version-%release

%description gnome
Simple Object Access Protocol implementation Library (GNOME part)

%package devel
Summary: Headers for HTTP client/server library for GNOME
Group: Development/C
Requires: %name = %version-%release
Provides: soup-devel = %version libsoup%api_ver-devel = %version
Obsoletes: soup-devel = %version libsoup%api_ver-devel < %version

%description devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package allows to develop applications that use the Soup library.

%package gnome-devel
Summary: Headers for HTTP client/server library for GNOME (GNOME part)
Group: Development/C
Requires: %name-gnome = %version-%release
Requires: %name-devel = %version-%release

%description gnome-devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package allows to develop applications that use the Soup library.

%package devel-doc
Summary: Development documentation for HTTP client/server library for GNOME
Group: Development/Documentation
Conflicts: %name < %version
Provides: libsoup%api_ver-devel-doc = %version
Obsoletes: libsoup%api_ver-devel-doc < %version
BuildArch: noarch

%description devel-doc
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package contains development documentation for Soup.

%package devel-static
Summary: Headers for Simple Object Access Protocol static library
Group: Development/C
Requires: %name-devel = %version-%release
Provides: soup-devel-static = %version libsoup%api_ver-devel-static = %version
Obsoletes: soup-devel-static < %version libsoup%api_ver-devel-static < %version

%description devel-static
This package allows to develop applications that statically linked
against Soup library.

%package gir
Summary: GObject introspection data for the Soup library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package provides GObject introspection data for the Soup library

%package gir-devel
Summary: GObject introspection devel data for the Soup library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package provides GObject introspection devel data for the Soup library

%package gnome-gir
Summary: GObject introspection data for the Soup-GNOME library
Group: System/Libraries
Requires: %name-gir = %version-%release
Requires: %name-gnome = %version-%release

%description gnome-gir
This package provides GObject introspection data for the GNOME part of Soup library

%package gnome-gir-devel
Summary: GObject introspection devel data for the Soup-GNOME library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir-devel = %version-%release
Requires: %name-gnome-gir = %version-%release

%description gnome-gir-devel
This package provides GObject introspection devel data for the GNOME
part of Soup library.

%prep
%setup
install -p -m644 %_sourcedir/%name-{,gnome-}compat.{map,lds} %name/
%patch1 -p1 -b .map

%build
%ifarch %e2k
%add_optflags -Wno-error=pointer-arith
%endif
%meson \
    %{?_enable_debug:--buildtype=debug} \
    %{?_enable_static:--default-library=both} \
    %{?_enable_gnome:-Dgnome=true} \
    %{?_enable_gtk_doc:-Ddoc=true} \
    %{?_enable_snapshot:-Ddoc=true} \
    %{?_enable_introspection:-Dintrospection=true} \
    %{?_enable_gssapi:-Dgssapi=true}
%meson_build

%install
%meson_install
%find_lang %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %name.lang
%_libdir/%name-%api_ver.so.*
%doc README NEWS AUTHORS

%files gnome
%_libdir/%name-gnome-%api_ver.so.*

%files devel
%_includedir/%name-%api_ver/
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%{?_enable_vala:%_vapidir/%name-%api_ver.vapi}
%{?_enable_vala:%_vapidir/%name-%api_ver.deps}

%files gnome-devel
%_includedir/%name-gnome-%api_ver/
%_libdir/%name-gnome-%api_ver.so
%_pkgconfigdir/%name-gnome-%api_ver.pc

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files gir
%_typelibdir/Soup-%api_ver.typelib

%files gir-devel
%_girdir/Soup-%api_ver.gir

%files gnome-gir
%_typelibdir/SoupGNOME-%api_ver.typelib

%files gnome-gir-devel
%_girdir/SoupGNOME-%api_ver.gir
%endif

%changelog
