Name: libspf2
Version: 1.2.10
Release: alt3

Summary: Implementation of the SPF specification
License: LGPLv2.1+
Group: System/Libraries

URL: http://www.libspf2.org/
Source0: http://libspf2.org/spf/libspf2-%version.tar.gz

Patch1: libspf2-alt-newgcc.patch

# Automatically added by buildreq on Mon Nov 03 2008
BuildRequires: gcc-c++

%description
Libspf2 is an implementation of the SPF specification as found at
http://tools.ietf.org/html/rfc7208

%package tools
Summary: Tools distributed with libspf2
Group: Networking/Other
Requires: %name = %version-%release

%description tools
Tools distributed with libspf2; at the time of writing: spf_example,
spf_example_2mx, spfd, spfquery and spftest.

%package devel
Summary: Development files for libspf2 library
Group: Development/C
Requires: %name = %version-%release

%description devel
Development files for libspf2 library.

%prep
%setup
%patch1 -p1

%build
# The configure script checks for the existence of __ns_get16 and uses the
# system-supplied version if found, otherwise one from src/libreplace.
# However, this function is marked GLIBC_PRIVATE in recent versions of glibc
# and shouldn't be called even if the configure script finds it. So we make
# sure that the configure script always uses the version in src/libreplace.
# This prevents us getting an unresolvable dependency in the built RPM.
cat > config.cache << EOF
ac_cv_func___ns_get16=no
EOF

%configure --cache-file=config.cache
# fix rpath libtool issues
subst 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
subst 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%make_build

%install
%makeinstall_std

%files
%_libdir/lib*.so.*

%files tools
%_bindir/*
%exclude %_bindir/*_static

%files devel
%doc LICENSES
%_includedir/*
%_libdir/*.so
%exclude %_libdir/*.a

%changelog
