%define ltversion 1.5
%define ltsoname 3
%define libtool libtool-%ltversion
%define libltdl libltdl%ltsoname

Name: libtool_%ltversion
Version: 1.5.26
Release: alt12
Epoch: 3

Summary: The GNU libtool, which simplifies the use of shared libraries
License: GPLv2+
Group: Development/Other
Url: http://www.gnu.org/software/libtool/libtool.html

%add_findreq_skiplist %_datadir/%libtool/config.guess
%set_compress_method xz

PreReq: libtool-common >= 0.2
Requires: autoconf
Requires: automake

# ftp://ftp.gnu.org/gnu/libtool/libtool-%version.tar.gz
Source: libtool-%version.tar

Patch: libtool-%version-%release.patch

BuildRequires: gcc-c++ gcc-g77 makeinfo

%package -n %libltdl
Summary: dlopen wrapper for GNU libtool
License: LGPLv2+
Group: System/Legacy libraries
Provides: libltdl = %EVR
Obsoletes: libltdl < %EVR

%package -n %libltdl-devel
Summary: Development files for %libltdl
License: LGPLv2+
Group: Development/C
Requires: %name = %EVR
Requires: %libltdl = %EVR
Provides: libltdl-devel = %EVR
Obsoletes: libltdl-devel < %EVR
Conflicts: libltdl7-devel

%package -n %libltdl-devel-static
Summary: Static %libltdl library
License: LGPLv2+
Group: Development/C
Requires: %libltdl-devel = %EVR
Provides: libltdl-devel-static = %EVR
Obsoletes: libltdl-devel-static < %EVR
Conflicts: libltdl7-devel-static

%package demos
Summary: Samples for Libtool
License: GPLv2+
Group: Development/Other
BuildArch: noarch
Requires: %name = %EVR

%description
The libtool package contains the GNU libtool, a set of shell scripts
which automatically configure UNIX and UNIX-like architectures to
generically build shared libraries.  Libtool provides a consistent,
portable interface which simplifies the process of using shared
libraries.

If you are developing programs which will use shared libraries, you
should install libtool.

%description -n %libltdl
This package contains libltdl shared library,
a system independent dlopen wrapper for GNU libtool.

%description -n %libltdl-devel
Development files for libltdl, a system independent
dlopen wrapper for GNU libtool.

%description -n %libltdl-devel-static
Static libltdl library, a system independent dlopen wrapper for GNU libtool.

%description demos
Sample programs and libraries to build with libtool.

%prep
%setup -n libtool-%version
%patch -p1

# fix testsuite
find -type f -name configure\* -print0 |
	xargs -r0 fgrep -lZ AM_CONFIG_HEADER -- |
	xargs -r0 sed -i s/AM_CONFIG_HEADER/AC_CONFIG_HEADERS/g --

# fix ld.so.conf.d support
find -type f -print0 |
	xargs -r0 fgrep -lZ 'cd /etc; cat %%s' -- |
	xargs -r0 sed -i 's|cd /etc; cat %%s|cd /etc \&\& cat %%s 2>/dev/null|g' --

# Hack in the version-specific package data dir and aclocal dir variables.
perl -pi -e 's|^(pkgdatadir=.*?)\s*$|$1-%ltversion\n|;' configure.ac

# Fix default vendor and lsattr.
sed -i 's|=pc|=%_vendor|g; s|/usr/sbin/lsattr|%_bindir/lsattr|g;' config.guess

# Eliminate gnutar dependencies.
find -type f -name missing -print0|
	xargs -r0 sed -i 's/gnutar /gnutar=gnutar \&\& \$&/' --

for f in config.guess config.sub; do
	ln -snf ../"$f" libltdl/
done

# Rename due to alternative editions.
sed -i '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].]\+\)\(:[[:space:]]\+\)(libtool)/\1-%ltversion\2(%libtool)/' \
	doc/libtool.texi
rm -f doc/*.info*

%build
export CC=gcc
export CXX=g++
export F77=g77
export GCJ=gcj

if [ -x bootstrap ]; then
	./bootstrap
else
autoreconf -iv
for d in *demo*; do
	ln -snf ../acinclude.m4 "$d"/
	autoreconf -iv "$d"
	ln -snf ../aclocal.m4 "$d"/
done
fi

%undefine __libtoolize
%configure --program-suffix=-%ltversion

# SMP-incompatible build?
make MAKEINFOFLAGS=--no-split
#sed -i "s/`hostname`/%buildhost/g" libtool

%check
# SMP incompatible check
make -k check

%install
%makeinstall

mkdir %buildroot%_datadir/%libtool/aclocal
mv %buildroot%_datadir/aclocal/libtool.m4 \
    %buildroot%_datadir/%libtool/aclocal/

mv %buildroot%_infodir/libtool{,-%ltversion}.info

for f in config.guess config.sub ltmain.sh; do
	ln -snf ../"$f" %buildroot%_datadir/%libtool/libltdl/
done

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo libtool >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name
mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
echo '^/usr/share/libtool(-1\.5)?/aclocal/.+\.m4$' >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name

%define ltdocdir %_docdir/libtool-%version
%define ltdldocdir %_docdir/libltdl-%version

mkdir -p %buildroot%ltdocdir
install -p -m644 acinclude.m4 aclocal.m4 AUTHORS NEWS README THANKS TODO \
    %buildroot%ltdocdir/
ln -rsnf %buildroot%_licensedir/GPL-2 \
	%buildroot%ltdocdir/COPYING
mkdir -p %buildroot%ltdldocdir
install -p -m644 libltdl/README %buildroot%ltdldocdir/
rm -f %buildroot%_datadir/%libtool/libltdl/COPYING.LIB
ln -rsnf %buildroot%_licensedir/LGPL-2.1 \
	%buildroot%_datadir/%libtool/libltdl/COPYING.LIB
ln -rsnf %buildroot%_licensedir/LGPL-2.1 \
	%buildroot%ltdldocdir/COPYING.LIB
for d in *demo*; do
	cp -a "$d" %buildroot%ltdocdir/
	rm -rf %buildroot%ltdocdir/"$d"/autom4te.cache
done
cp -p install-sh missing %buildroot%ltdocdir/demo/

%files
%_bindir/*
%_datadir/%libtool
%_infodir/%libtool.info*
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/%name
%dir %ltdocdir
%ltdocdir/[A-Z]*

%files -n %libltdl
%_libdir/*.so.*
%dir %ltdldocdir
%ltdldocdir/README
%ltdldocdir/COPYING.LIB

%files -n %libltdl-devel
%_libdir/*.so
%_includedir/*
%_datadir/aclocal/ltdl.m4

%files -n %libltdl-devel-static
%_libdir/*.a

%files demos
%dir %ltdocdir
%ltdocdir/*.m4
%ltdocdir/*demo*

%changelog
