%define ltversion 2.4
%define ltsoname 7
%define libtool libtool-%ltversion
%define libltdl libltdl%ltsoname

Name: libtool_%ltversion
Version: 2.4.6
Release: alt1

Summary: The GNU libtool, which simplifies the use of shared libraries
License: GPLv2+
Group: Development/Other
Url: https://www.gnu.org/software/libtool/

%set_compress_method xz

Requires: libtool-common >= 0.2
Requires: autoconf
Requires: automake

# git://git.altlinux.org/gears/l/%name.git
Source: libtool-%version-%release.tar

BuildRequires: gnulib >= 0.1.2433.3043e
BuildRequires: gnulib-modules-bootstrap >= 0.0.70.037f
BuildRequires: gcc-c++ gcc-g77 help2man makeinfo
# for tests/search-path.at
BuildRequires: zlib-devel

%package -n %libltdl
Summary: dlopen wrapper for GNU libtool
License: LGPLv2+
Group: System/Libraries

%package -n %libltdl-devel
Summary: Development files for %libltdl
License: LGPLv2+
Group: Development/C
Requires: %name = %EVR
Requires: %libltdl = %EVR
Provides: libltdl-devel = 3:%version-%release
Conflicts: libltdl-devel < 3:%version

%package -n %libltdl-devel-static
Summary: Static %libltdl library
License: LGPLv2+
Group: Development/C
Requires: %libltdl-devel = %EVR
Provides: libltdl-devel-static = 3:%version
Obsoletes: libltdl-devel-static < 3:%version

%description
The libtool package contains the GNU libtool, a set of shell scripts
which automatically configure UNIX and UNIX-like architectures to
generically build shared libraries.  Libtool provides a consistent,
portable interface which simplifies the process of using shared
libraries.

If you are developing programs which will use shared libraries, you
should install libtool.

%description -n %libltdl
This package contains libltdl shared library,
a system independent dlopen wrapper for GNU libtool.

%description -n %libltdl-devel
Development files for libltdl, a system independent
dlopen wrapper for GNU libtool.

%description -n %libltdl-devel-static
Static libltdl library, a system independent dlopen wrapper for GNU libtool.

%prep
%setup -n libtool-%version
cp -a %_datadir/gnulib-modules-bootstrap/* gl-mod/bootstrap/

# Build scripts expect to find these files.
echo -n %version > .tarball-version
echo -n 4223 > .serial

# Rename due to alternative editions.
sed -i '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].]\+\)\(:[[:space:]]\+\)(libtool)/\1-%ltversion\2(%libtool)/' \
	doc/libtool.texi

%build
./bootstrap --skip-po --skip-git --gnulib-srcdir=%_datadir/gnulib
%configure --program-suffix=-%ltversion --disable-silent-rules

%make_build MAKEINFOFLAGS=--no-split
# Do not hardcode gcc path information, and do not use -nostdlib.
sed -i -e 's/^\(predep_objects\|postdep_objects\|compiler_lib_search_path\)=.*/\1=""/' \
       -e 's/^\(archive\(_expsym\)\?_cmds=\".*\) -nostdlib /\1 /' libtool

%check
# Remove -frecord-gcc-switches because it confuses demo-hardcode.test.
%make_build -k check VERBOSE=1 CFLAGS="${RPM_OPT_FLAGS/-frecord-gcc-switches/}"

%install
%makeinstall_std
mv %buildroot%_infodir/libtool{,-%ltversion}.info

out="\$(\$CC -print-search-dirs |\$SED -e '/^libraries: *=/!d;s///;s!/:!:!g;s!/\$!!;s/:/ /g')"
sed -i 's#^\(compiler_lib_search_dirs="\)/.*#\1'"$out"'"#' %buildroot%_bindir/%libtool

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo libtool >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name
mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
echo '^/usr/share/libtool(-2\.4)?/aclocal/.+\.m4$' >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name

%define ltdocdir %_docdir/libtool-%version
%define ltdldocdir %_docdir/libltdl-%version

mkdir -p %buildroot%ltdocdir
install -p -m644 AUTHORS NEWS README TODO %buildroot%ltdocdir/
ln -rsnf %buildroot%_licensedir/GPL-2 \
	%buildroot%ltdocdir/COPYING
mkdir -p %buildroot%ltdldocdir
install -p -m644 libltdl/README %buildroot%ltdldocdir/
rm %buildroot%_datadir/%libtool/libltdl/COPYING.LIB
ln -rsnf %buildroot%_licensedir/LGPL-2.1 \
	%buildroot%_datadir/%libtool/libltdl/COPYING.LIB
ln -rsnf %buildroot%_licensedir/LGPL-2.1 \
	%buildroot%ltdldocdir/COPYING.LIB

# This config.guess file usually emits tons of unwanted deps.
%add_findreq_skiplist %_datadir/%libtool/build-aux/config.guess

%define _unpackaged_files_terminate_build 1

%files
%_bindir/*
%_datadir/%libtool
%_infodir/%libtool.info*
%_man1dir/%libtool.1*
%_man1dir/libtoolize-%ltversion.1*
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/%name
%dir %ltdocdir
%ltdocdir/[A-Z]*

%files -n %libltdl
%_libdir/*.so.*
%dir %ltdldocdir
%ltdldocdir/README
%ltdldocdir/COPYING.LIB

%files -n %libltdl-devel
%_libdir/*.so
%_includedir/*

%files -n %libltdl-devel-static
%_libdir/*.a

%changelog
