%define s_name unique
%def_disable introspection

Name: lib%s_name
Version: 1.1.6
Release: alt7.1

Summary: is a library for writing single instance application
License: LGPL
Group: System/Libraries
Url: http://live.gnome.org/LibUnique
Packager: Vladimir Lettiev <crux@altlinux.ru>

Source: %name-%version.tar
Patch: libunique-1.1.6-fc-fix-unused-but-set-variable.patch
Patch1: libunique-1.1.6-fc-fix-disable-deprecated.patch
Patch2: libunique-1.1.6-alt-no-Werror.patch

BuildPreReq: rpm-build-gnome gnome-common
BuildRequires: glib2-devel libdbus-devel libdbus-glib-devel libgtk+2-devel gtk-doc
BuildRequires: gobject-introspection-devel >= 0.9.5 libgtk+2-gir-devel
%{?_enable_introspection: BuildRequires: libgtk+2-gir-devel}

%description
Unique is a library for writing single instance application. If you
launch a single instance application twice, the second instance will
either just quit or will send a message to the running instance.
Unique makes it easy to write this kind of applications, by providing a
base class, taking care of all the IPC machinery needed to send messages
to a running instance, and also handling the startup notification side.
Unique aims to replace the BaconMessageConnection code that has been
copied by many projects and the code using Bonobo and D-Bus.
This package contains the shared library.

%package devel
Summary: is a library for writing single instance application. Development files.
Group: Development/C
PreReq: %name = %version-%release

%description devel
Unique is a library for writing single instance application. If you
launch a single instance application twice, the second instance will
either just quit or will send a message to the running instance.
Unique makes it easy to write this kind of applications, by providing a
base class, taking care of all the IPC machinery needed to send messages
to a running instance, and also handling the startup notification side.
Unique aims to replace the BaconMessageConnection code that has been
copied by many projects and the code using Bonobo and D-Bus.
This package contain development files.

%package gir
Summary: GObject introspection data for the Unique library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Unique library

%package gir-devel
Summary: GObject introspection devel data for the Unique library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Unique library

%prep
%setup
%patch -p1 -b .unused-but-set-variable
%patch1 -p1 -b .disable-deprecated
%patch2 -p2

%build
%autoreconf
%configure --enable-gtk-doc --disable-static \
	%{?_disable_introspection:--enable-introspection=no}
%make_build V=1

%install
%makeinstall_std

%files
%_libdir/%name-1.0.so.*

%files devel
%_includedir/%s_name-1.0
%_libdir/pkgconfig/%s_name-1.0.pc
%_libdir/%name-1.0.so
%_datadir/gtk-doc/html/%s_name/*
%doc AUTHORS ChangeLog NEWS README

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/Unique-1.0.typelib

%files gir-devel
%_datadir/gir-1.0/Unique-1.0.gir
%endif

%changelog
