Name: libusb-compat
Version: 0.1.5
Release: alt1
Summary: Libusb is a library which allows userspace access to USB devices
License: LGPL
Group: System/Libraries
Url: http://sourceforge.net/projects/libusb/
Packager: Alexander Bokovoy <ab@altlinux.org>

Prereq: libusb >= 1.0.1-alt1

Source0: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: libusb-devel >= 1.0-alt2

%description
Libusb is a library which allows userspace access to USB devices.
Libusb-compat implements compatibility interfaces of libusb 0.1.

%package devel
Summary: Libusb-compat is a wrapper which allows userspace access to USB devices via older (0.1.0) API of libusb
Group: Development/C
Requires: %name = %version-%release

%description devel
Libusb-compat is a wrapper which allows userspace access to USB devices via older (0.1.0) API of libusb

This package contains header files needed for the development of programs that
use libusb.

Use of 0.1.0 API of libusb is discouraged, please port your applications to libusb 1.0 API!

%prep
%setup -q
%patch -p1

mkdir -p m4

%build
%autoreconf
%configure \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/lib*.so; do
	t=$(readlink "$f")
	ln -sf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/lib*.so.* %buildroot/%_lib/

%files
%doc AUTHORS README NEWS
/%_lib/libusb-0.1.so.*

%files devel
%_includedir/usb.h
%_bindir/libusb-config
%_libdir/libusb.so
%_pkgconfigdir/libusb.pc

%changelog
