%def_enable drm
%def_enable glx
%def_enable x11

Name: libva
Version: 2.11.0
Release: alt1

Summary: Video Acceleration (VA) API for Linux
License: MIT
Group: System/Libraries
Url: https://github.com/01org/libva


Source: %name-%version.tar
Patch: %name-%version-alt.patch

%if_enabled drm
BuildRequires: libdrm-devel
%endif
%if_enabled glx
BuildRequires: libGL-devel
%endif
%if_enabled x11
BuildRequires: libXext-devel libXfixes-devel
%endif
BuildRequires: gcc-c++ libwayland-client-devel libwayland-server-devel

%description
Video Acceleration (VA) API for Linux - runtime
The libva library implements the Video Acceleration (VA) API for Linux.
The library loads a hardware dependendent driver.

Note also that VAAPI intel driver now resides in own package:
libva-driver-intel

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release
Requires: glibc-kernheaders
Obsoletes: libva1-devel < %version-%release

%description devel
This package provides the development environment for libva

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	%{subst_enable drm} \
	%{subst_enable glx} \
	%{subst_enable x11} \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

%files
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
