Name: libvorbis
Version: 1.3.6
Release: alt2

Summary: The Vorbis General Audio Compression Codec
Summary(ru_RU.UTF-8): Аудиокодек Vorbis
License: BSD-3-Clause
Group: System/Libraries
Url: http://www.xiph.org/vorbis/
# http://downloads.xiph.org/releases/vorbis/%name-%version.tar.bz2
Source: %name-%version.tar
Patch1: 0001-vorbisenc-detect-if-new_template-is-NULL.patch
Patch2: 0002-CVE-2017-14160-fix-bounds-check-on-very-low-sample-r.patch
Patch3: 0003-Clamp-large-exponents-in-float32_unpack.patch
Patch4: 0004-Sanity-check-number-of-channels-in-setup.patch
Patch5: 0005-Fix-shift-by-negative-value-when-reading-blocksize.patch
Patch11: libvorbis-1.3.2-alt-export-symbols.patch
Patch12: libvorbis-1.3.6-alt-add-needed.patch
Patch13: libvorbis-1.3.5-alt-configure.patch

BuildRequires: libogg-devel

%def_disable static

%description
Ogg Vorbis is a fully open, non-proprietary, patent-and-royalty-free,
general-purpose compressed audio format for audio and music at fixed
and variable bitrates from 16 to 128 kbps/channel.

%description -l ru_RU.UTF-8
Ogg Vorbis - это полностью открытый и свободный формат для сжатия звука.

%package devel
Summary: Development files for libvorbis
Group: Development/C
Requires: %name = %version-%release
Requires: libogg-devel

%description devel
The libvorbis-devel package contains the header files and documentation
needed to develop applications with libvorbis.

%description devel -l ru_RU.UTF-8
В этом пакете находятся файлы, необходимые для использования libvorbis
в разработке приложений.

%package devel-static
Summary: Static libraries for libvorbis
Group: Development/C
Requires: %name-devel = %version-%release
Requires: libogg-devel-static

%description devel-static
This package contains development libraries required for packaging
statically linked libvorbis-based software.

%description devel-static -l ru_RU.UTF-8
В этом пакете находятся статические библиотеки, необходимые
для использования libvorbis в разработке статических приложений.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch11 -p1
%patch12 -p2
%patch13 -p1
for f in m4/*.m4; do
	[ ! -f "%_datadir/aclocal/${f##*/}" ] ||
		rm -fv "$f"
done
# include "config.h" first
pattern='^[[:space:]]*#[[:space:]]*include[[:space:]]'
grep -l "$pattern" lib/*.c |
	xargs -r sed -i '0,/'"$pattern"'/ s/'"$pattern"'/#include "config.h"\n&/'
# restrict lists of global symbols exported by libraries
sed -n 's/^extern[[:space:]]\+[^(]*[[:space:]]\**\([a-z][^()[:space:]]\+\)[[:space:]]*(.*/\1/p' \
	include/vorbis/*.h > lib/libvorbis.sym
# extra symbols required by packages
cat >> lib/libvorbis.sym <<'EOF'
vorbis_window
EOF
sort -u -o lib/libvorbis.sym{,}

%build
%autoreconf
%configure %{subst_enable static} --disable-silent-rules
%make_build

%install
%define docdir %_docdir/%name
%makeinstall_std docdir=%docdir
install -pm644 AUTHORS CHANGES COPYING %buildroot%docdir/
%set_verify_elf_method strict

%check
# SMP-incompatible check
make -k check

%files
%_libdir/*.so.*
%dir %docdir/
%docdir/[A-Z]*

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_aclocaldir/*
%dir %docdir/
%docdir/[a-z]*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
