Name: libwmf
Version: 0.2.8.4
Release: alt13

Summary: A library to convert wmf files
License: GPL
Group: Text tools
Url: http://sourceforge.net/projects/wvware

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: fonts-type1-urw
Obsoletes: wmf-fonts < %version-%release

Source: %name-%version.tar.bz2
Patch0: libwmf-0.2.6-cflags.patch
Patch1: libwmf-0.2.8.3-CAN-2004-0941.patch
Patch2: libwmf-0.2.8.3-CAN-2004-0990.patch
Patch3: libwmf-0.2.8.4-CVE-2007-0455.patch
Patch4: libwmf-0.2.8.4-CVE-2007-2756.patch
Patch5: libwmf-0.2.8.4-CVE-2007-3472.patch
Patch6: libwmf-0.2.8.4-CVE-2007-3473.patch
Patch7: libwmf-0.2.8.4-CVE-2007-3477.patch
Patch8: libwmf-0.2.8.4-CVE-2009-1364.patch
Patch9: libwmf-0.2.8.4-CVE-2009-3546.patch
Patch10: libwmf-0.2.8.4-intoverflow.patch
Patch11: libwmf-0.2.8.4-pixbufloaderdir.patch
Patch12: libwmf-0.2.8.4-reducesymbols.patch
Patch13: libwmf-0.2.8.4-fallbackfont.patch
Patch14: CVE-2015-0848_CVE-2015-4588_CVE-2015-4695_CVE-2015-4696.patch
Patch15: CVE-2016-9011.patch

BuildRequires: libICE-devel libexpat-devel libfreetype-devel libgdk-pixbuf-devel libjpeg-devel libpng-devel

%description
%name is a library for unix like machines that can convert wmf
files into other formats, currently it supports a gd binding
to convert to gif, and an X one to draw direct to an X window
or pixmap.

%package -n %{name}lite
Summary: A library to convert wmf files
Group: System/Libraries

%description -n %{name}lite
%{name}lite is a library for unix like machines that can convert wmf
files into other formats, currently it supports a gd binding
to convert to gif, and an X one to draw direct to an X window
or pixmap.

%package -n wmf-utils
Summary: Utilities to convert wmf files
Group: Text tools
Requires: %name = %version-%release

%description -n wmf-utils
This package contains various programs for manipulating files in
the WMF format.

%package -n wmf-gtk-loader
Summary: GDK-pixbuf loader for WMF files
Group: System/Libraries

%description -n wmf-gtk-loader
WMF file loader for the GTK+ image manipulation library, GDK-pixbuf.

%package devel
Summary: A library to convert wmf files - development environment
Group: Development/C
Requires: %name = %version-%release %{name}lite = %version-%release

%description devel
%name is a library for unix like machines that can convert wmf
files into other formats, currently it supports a gd binding
to convert to gif, and an X one to draw direct to an X window
or pixmap.

Install %name-devel if you need to compile an application with %name
support.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
#%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1

rm -f configure.in

%build
%autoreconf
%configure \
	--disable-static \
	--with-fontdir=%_datadir/fonts/type1/urw \
	--with-xtrafontmap=%_datadir/%name/fontmap \
	--with-docdir=%_docdir/%name-%version
%make_build

%install
%make DESTDIR=%buildroot install

install -pD -m644 fonts/fontmap %buildroot%_datadir/%name/fontmap

%files
%doc AUTHORS README
%_libdir/%name-*.so.*
%_datadir/%name

%files -n %{name}lite
%_libdir/%{name}lite-*.so.*

%files -n wmf-utils
%_bindir/wmf2*

%files -n wmf-gtk-loader
%_libdir/gdk-pixbuf-2.0/*/loaders/*.so

%files devel
%_libdir/*.so
%_bindir/%name-config
%_includedir/%name
%_docdir/%name-%version

%changelog
