Name: libwpd10
Version: 0.10.2
Release: alt1

Summary: Library for reading and converting WordPerfect(tm) documents

License: LGPL
Group: System/Libraries
Url: http://libwpd.sf.net/

Source: libwpd-%version.tar.xz

# Automatically added by buildreq on Tue Feb 20 2018
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 libstdc++-devel perl perl-Encode perl-Locale-gettext perl-parent pkg-config python-base xz
BuildRequires: boost-devel-headers doxygen gcc-c++ help2man librevenge-devel

BuildRequires: gcc-c++
BuildRequires: doxygen
BuildRequires: pkgconfig(cppunit)
BuildRequires: pkgconfig(zlib)

Obsoletes: libwpd9 >= 0.10.0

%description
Library that handles Word Perfect documents

%package tools
Summary: Tools to transform WordPerfect Documents into other formats
Group: Publishing
Requires: %name = %version-%release
Conflicts: libwpd-tools < %version
Conflicts: libwpd9-tools < %version

%description tools
Tools to transform WordPerfect Documents into other formats.
Currently supported: html, raw, text

%package devel
Summary: Files for developing with libwpd
Group: Development/C++
Requires: %name = %version-%release
Conflicts: libwpd-devel < %version
Conflicts: libwpd9-devel < %version

%description devel
Includes and definitions for developing with libwpd

%package doc
Summary: Documentation of %name API
Group: Documentation
BuildArch: noarch

%description doc
The %name-doc package contains API documentation for %name.

%prep
%setup -n libwpd-%version

%build
%autoreconf
%configure --disable-static --disable-werror
%make_build

export LD_LIBRARY_PATH=`pwd`/src/lib/.libs${LD_LIBRARY_PATH:+:${LD_LIBRARY_PATH}}
help2man -N -n 'debug the conversion library' -o wpd2raw.1 ./src/conv/raw/.libs/wpd2raw
help2man -N -n 'convert WordPerfect document into HTML' -o wpd2html.1 ./src/conv/html/.libs/wpd2html
help2man -N -n 'convert WordPerfect document into plain text' -o wpd2text.1 ./src/conv/text/.libs/wpd2text

%install
%makeinstall_std
# we install API docs directly from build
rm -rf %buildroot%_docdir/libwpd

install -m 0755 -d %buildroot%_man1dir
install -m 0644 wpd2*.1 %buildroot%_man1dir/

%check
LD_LIBRARY_PATH=../lib/.libs make check

%files
%doc COPYING.LGPL COPYING.MPL CREDITS README
%_libdir/*.so.*

%files tools
%_bindir/*
%_man1dir/*.1*

%files devel
%doc HACKING TODO
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files doc
%doc COPYING.LGPL COPYING.MPL
%doc docs/doxygen/html
%doc docs/*.dia
%doc docs/*.png

%changelog
