%define oname xerces-c

%ifarch alpha ppc64 s390x sparc64 x86_64 ia64
%define rcopts -b 64
%else
%define rcopts -b 32
%endif

# threads
# values: pthreads, none
%define threads pthreads

Name: libxerces-c
Version: 3.2.2
Release: alt1.qa1

Summary: Xerces-C++ validating XML parser

Url: http://xml.apache.org/xerces-c/
License: Apache
Group: System/Libraries

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: http://apache-mirror.rbc.ru/pub/apache//xerces/c/3/sources/xerces-c-%version.tar.bz2
Source: %oname-%version.tar

# Automatically added by buildreq on Wed Mar 09 2005
BuildRequires: gcc-c++ libstdc++-devel

Conflicts: %name-utils < %version-%release

%description
Xerces-C++ is a validating XML parser written in a portable subset of C++.
Xerces-C++ makes it easy to give your application the ability to read and
write XML data. A shared library is provided for parsing, generating,
manipulating, and validating XML documents.

The parser provides high performance, modularity, and scalability. Source
code, samples and API documentation are provided with the parser. For
portability, care has been taken to make minimal use of templates, no RTTI,
and minimal use of #ifdefs.

%package utils
Summary: Utils for Xerces-C++ validating XML parser
Group: File tools
Requires: %name = %version-%release
Conflicts: libxerces-c28-utils

%description utils
Xerces-C++ is a validating XML parser written in a portable subset of C++.
Xerces-C++ makes it easy to give your application the ability to read and
write XML data. A shared library is provided for parsing, generating,
manipulating, and validating XML documents.

The parser provides high performance, modularity, and scalability. Source
code, samples and API documentation are provided with the parser. For
portability, care has been taken to make minimal use of templates, no RTTI,
and minimal use of #ifdefs.

This package contains utils for Xerces-C++ validating XML parser.

%package devel
Group: System/Libraries
Summary: Header files for Xerces-C++ validating XML parser
Requires: %name = %version
Provides: xerces-c-devel = %version
Conflicts: libxerces-c28-devel
Obsoletes: xerces-c-devel

%description devel
Header files you can use to develop XML applications with Xerces-C++.

Xerces-C++ is a validating XML parser written in a portable subset of C++.
Xerces-C++ makes it easy to give your application the ability to read and
write XML data. A shared library is provided for parsing, generating,
manipulating, and validating XML documents.

%package doc
Group: System/Libraries
Summary: Documentation for Xerces-C++ validating XML parser
Provides: xerces-c-doc = %version
Obsoletes: xerces-c-doc
Conflicts: libxerces-c28-doc
BuildArch: noarch

%description doc
Documentation for Xerces-C++.

Xerces-C++ is a validating XML parser written in a portable subset of C++.
Xerces-C++ makes it easy to give your application the ability to read and
write XML data. A shared library is provided for parsing, generating,
manipulating, and validating XML documents.

%prep
%setup -q -n %oname-%version

%build
%configure --disable-static --enable-transcoder-iconv
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall_std

# There is a file in the package with a name starting with <tt>._</tt>, 
# the file name pattern used by Mac OS X to store resource forks in non-native 
# file systems. Such files are generally useless in packages and were usually 
# accidentally included by copying complete directories from the source tarball.
find $RPM_BUILD_ROOT -name '._*' -size 1 -print0 | xargs -0 grep -lZ 'Mac OS X' -- | xargs -0 rm -f
# for ones installed as %%doc
find . -name '._*' -size 1 -print0 | xargs -0 grep -lZ 'Mac OS X' -- | xargs -0 rm -f


#rm -f %buildroot%_libdir/%name.a

%files
%_libdir/libxerces-c-*.so

%files devel
%_includedir/xercesc/
%_libdir/%name.so
%_pkgconfigdir/xerces-c.pc

%files doc
%doc LICENSE NOTICE CREDITS doc/

%files utils
%_bindir/*

%changelog
