%define plugin_version 2.7

Name: libxine2
Version: 1.2.9
Release: alt2

Summary: Free libraries for play video and audio
License: GPLv2+
Group: System/Libraries
Url: http://xinehq.de/

Source: %name-%version.tar

BuildRequires: libfreetype-devel fontconfig-devel
BuildRequires: libalsa-devel libjack-devel libpulseaudio-devel
BuildRequires: libGL-devel libGLU-devel libSDL-devel
BuildRequires: libxcb-devel libXinerama-devel libXv-devel libXvMC-devel libva-devel libvdpau-devel
BuildRequires: gnome-vfs-devel libsmbclient-devel
BuildRequires: libv4l-devel libdvdread-devel libdvdnav-devel libcdio-devel libbluray-devel
BuildRequires: libavformat-devel libavcodec-devel libavutil-devel libpostproc-devel
BuildRequires: libgdk-pixbuf-devel libjpeg-devel libGraphicsMagick-devel
BuildRequires: liba52-devel libdca-devel libfaad-devel libflac-devel libmad-devel
BuildRequires: libmodplug-devel libmpcdec-devel libmng-devel libspeex-devel
BuildRequires: libtheora-devel libvorbis-devel libwavpack-devel
BuildRequires: libfame-devel libvcd-devel libvpx-devel
BuildRequires: librsvg-utils lynx xmlto

%description
%name is a free gpl-licensed video player libraries and plugins for
unix-like systems. It supports mpeg-2 and mpeg-1 streams as well as AVI
files that contain MS MPEG-4 / DivX / XviD Video.

%package devel
Summary: Includes for xine development
Group: Development/Other
Requires: %name = %version-%release
Conflicts: libxine-devel

%package -n xine2-plugin-gnomevfs
Summary: gnome-vfs input plugin for xine
Group: System/Libraries
PreReq: %name = %version-%release
Provides: xine-plugin-input-gnomevfs = %version
Obsoletes: xine-plugin-input-gnomevfs < %version

%package -n xine2-plugin-samba
Summary: samba input plugin for xine
Group: System/Libraries
PreReq: %name = %version-%release

%description devel
This package contains the include files for development for xine video
output libraries.

%description -n xine2-plugin-gnomevfs
gnome-vfs input plugin for xine.

%description -n xine2-plugin-samba
samba input plugin for xine.

%prep
%setup

%build
%autoreconf
%configure \
	--enable-ipv6 \
	--enable-antialiasing \
	--enable-mmap \
	--enable-shared \
	--disable-oss \
	--with-external-dvdnav \
#
%make_build

%install
%make DESTDIR=%buildroot docdir=%_docdir/%name-devel-%version htmldir=%_docdir/%name-devel-%version/html install
mv %buildroot%_man5dir/xine.5 %buildroot%_man5dir/xine2.5

%find_lang %name

%files -f %name.lang
%_libdir/libxine.so.*
%_libdir/xine/plugins/%plugin_version
%exclude %_libdir/xine/plugins/%plugin_version/xineplug_inp_gnome_vfs.so
%exclude %_libdir/xine/plugins/%plugin_version/xineplug_inp_smb.so
%_datadir/xine-lib
%_man5dir/xine2.*

%files devel
%doc %_docdir/%name-devel-%version
%_bindir/*
%_libdir/libxine.so
%_includedir/xine*
%_datadir/aclocal/*
%_pkgconfigdir/*.pc
%_man1dir/*

%files -n xine2-plugin-gnomevfs
%_libdir/xine/plugins/%plugin_version/xineplug_inp_gnome_vfs.so

%files -n xine2-plugin-samba
%_libdir/xine/plugins/%plugin_version/xineplug_inp_smb.so

%changelog
