%def_enable snapshot
%def_enable docs

%define ver_major 2.40
%define xml_ver 2.6
%define _name libxml++

Name: %{_name}2
Version: %ver_major.1
Release: alt3

Summary: C++ wrapper for the libxml2 XML parser library
Group: System/Libraries
License: LGPLv2+
Url: http://libxmlplusplus.sourceforge.net/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif
Patch: libxml++-0f5aa54.patch

BuildPreReq: mm-common gcc-c++
BuildRequires: libxml2-devel >= 2.6.1 libglibmm-devel >= 2.46.0
%{?_enable_docs:BuildRequires: doxygen graphviz docbook-style-xsl xsltproc}

%description
libxml++ is a C++ wrapper for the libxml2 XML parser library.
It has SAX and DOM-like APIs, but does not attempt to conform exactly to
the DOM specification. Its API is simpler than the underlying libxml2 C API.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release

%description devel
This package contains the headers and libraries for libxml++ development.

%package devel-doc
Summary: Development documentation for %name
Group: Development/C++
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains the development documentation for libxml++ library.

%prep
%setup -n %_name-%version
%patch -p1 -R -b .0f5aa54

#sed -i 's|\(doctooldir\)\ glibmm\-2\.4|\1 mm-common-util|' configure

%build
mm-common-prepare --force --copy
%autoreconf
%configure --disable-static \
    %{?_enable_snapshot:--enable-maintainer-mode} \
    %{?_disable_docs:--disable-documentation}
%make_build

%install
%makeinstall_std

%files

%_libdir/*.so.*
%doc AUTHORS NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/%_name-%xml_ver
%_pkgconfigdir/*

%files devel-doc
%_datadir/devhelp/books/%_name-%xml_ver/*.devhelp2
%_docdir/%_name-%xml_ver/*

%changelog
