# rt-tests is taken by perl tests for RT
Name:     linux-rt-tests
Version:  1.8
Release:  alt1

Summary:  Programs that test various rt-linux features
License:  GPL-2.0-or-later
Group:    System/Kernel and hardware
# git://git.kernel.org/pub/scm/utils/rt-tests/rt-tests.git
Url:      https://wiki.linuxfoundation.org/realtime/documentation/howto/tools/rt-tests

Source:   %name-%version.tar
BuildRequires: libnuma-devel rpm-build-python3

%description
rt-tests is a test suite, that contains programs (such as cyclictest,
hwlatdetect, hackbench) to test various Real Time Linux features.

%prep
%setup

%build
%make_build prefix=/usr

%install
%makeinstall_std prefix=/usr

rm -f %buildroot/usr/bin/hwlatdetect \
      %buildroot/usr/lib/python3/site-packages/hwlatdetect.py
install -D src/hwlatdetect/hwlatdetect.py %buildroot/usr/sbin/hwlatdetect

%files
%_bindir/cyclicdeadline
%_bindir/cyclictest
%_bindir/deadline_test
%_bindir/determine_maximum_mpps.sh
%_bindir/get_cpuinfo_mhz.sh
%_bindir/hackbench
%_bindir/pi_stress
%_bindir/pip_stress
%_bindir/pmqtest
%_bindir/ptsematest
%_bindir/queuelat
%_bindir/rt-migrate-test
%_bindir/signaltest
%_bindir/sigwaittest
%_bindir/ssdd
%_bindir/svsematest
%_sbindir/hwlatdetect
%_man8dir/*.8*
%doc COPYING MAINTAINERS README.markdown src/hwlatdetect/hwlat.txt

%changelog
